/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.mediaconvert.model.HlsAdMarkers;
import software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageMapping;
import software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageSetting;
import software.amazon.awssdk.services.mediaconvert.model.HlsClientCache;
import software.amazon.awssdk.services.mediaconvert.model.HlsCodecSpecification;
import software.amazon.awssdk.services.mediaconvert.model.HlsDirectoryStructure;
import software.amazon.awssdk.services.mediaconvert.model.HlsEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.HlsManifestCompression;
import software.amazon.awssdk.services.mediaconvert.model.HlsManifestDurationFormat;
import software.amazon.awssdk.services.mediaconvert.model.HlsOutputSelection;
import software.amazon.awssdk.services.mediaconvert.model.HlsProgramDateTime;
import software.amazon.awssdk.services.mediaconvert.model.HlsSegmentControl;
import software.amazon.awssdk.services.mediaconvert.model.HlsStreamInfResolution;
import software.amazon.awssdk.services.mediaconvert.model.HlsTimedMetadataId3Frame;
import software.amazon.awssdk.services.mediaconvert.model.ListOfHlsAdMarkersCopier;
import software.amazon.awssdk.services.mediaconvert.model.ListOfHlsCaptionLanguageMappingCopier;
import software.amazon.awssdk.services.mediaconvert.transform.HlsGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsGroupSettings> {
    private final List<String> adMarkers;
    private final String baseUrl;
    private final List<HlsCaptionLanguageMapping> captionLanguageMappings;
    private final String captionLanguageSetting;
    private final String clientCache;
    private final String codecSpecification;
    private final String destination;
    private final String directoryStructure;
    private final HlsEncryptionSettings encryption;
    private final String manifestCompression;
    private final String manifestDurationFormat;
    private final Integer minSegmentLength;
    private final String outputSelection;
    private final String programDateTime;
    private final Integer programDateTimePeriod;
    private final String segmentControl;
    private final Integer segmentLength;
    private final Integer segmentsPerSubdirectory;
    private final String streamInfResolution;
    private final String timedMetadataId3Frame;
    private final Integer timedMetadataId3Period;
    private final Integer timestampDeltaMilliseconds;

    private HlsGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.baseUrl = builder.baseUrl;
        this.captionLanguageMappings = builder.captionLanguageMappings;
        this.captionLanguageSetting = builder.captionLanguageSetting;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.destination = builder.destination;
        this.directoryStructure = builder.directoryStructure;
        this.encryption = builder.encryption;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minSegmentLength = builder.minSegmentLength;
        this.outputSelection = builder.outputSelection;
        this.programDateTime = builder.programDateTime;
        this.programDateTimePeriod = builder.programDateTimePeriod;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.segmentsPerSubdirectory = builder.segmentsPerSubdirectory;
        this.streamInfResolution = builder.streamInfResolution;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
        this.timestampDeltaMilliseconds = builder.timestampDeltaMilliseconds;
    }

    public List<HlsAdMarkers> adMarkers() {
        return TypeConverter.convert(this.adMarkers, HlsAdMarkers::fromValue);
    }

    public List<String> adMarkersStrings() {
        return this.adMarkers;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public List<HlsCaptionLanguageMapping> captionLanguageMappings() {
        return this.captionLanguageMappings;
    }

    public HlsCaptionLanguageSetting captionLanguageSetting() {
        return HlsCaptionLanguageSetting.fromValue(this.captionLanguageSetting);
    }

    public String captionLanguageSettingString() {
        return this.captionLanguageSetting;
    }

    public HlsClientCache clientCache() {
        return HlsClientCache.fromValue(this.clientCache);
    }

    public String clientCacheString() {
        return this.clientCache;
    }

    public HlsCodecSpecification codecSpecification() {
        return HlsCodecSpecification.fromValue(this.codecSpecification);
    }

    public String codecSpecificationString() {
        return this.codecSpecification;
    }

    public String destination() {
        return this.destination;
    }

    public HlsDirectoryStructure directoryStructure() {
        return HlsDirectoryStructure.fromValue(this.directoryStructure);
    }

    public String directoryStructureString() {
        return this.directoryStructure;
    }

    public HlsEncryptionSettings encryption() {
        return this.encryption;
    }

    public HlsManifestCompression manifestCompression() {
        return HlsManifestCompression.fromValue(this.manifestCompression);
    }

    public String manifestCompressionString() {
        return this.manifestCompression;
    }

    public HlsManifestDurationFormat manifestDurationFormat() {
        return HlsManifestDurationFormat.fromValue(this.manifestDurationFormat);
    }

    public String manifestDurationFormatString() {
        return this.manifestDurationFormat;
    }

    public Integer minSegmentLength() {
        return this.minSegmentLength;
    }

    public HlsOutputSelection outputSelection() {
        return HlsOutputSelection.fromValue(this.outputSelection);
    }

    public String outputSelectionString() {
        return this.outputSelection;
    }

    public HlsProgramDateTime programDateTime() {
        return HlsProgramDateTime.fromValue(this.programDateTime);
    }

    public String programDateTimeString() {
        return this.programDateTime;
    }

    public Integer programDateTimePeriod() {
        return this.programDateTimePeriod;
    }

    public HlsSegmentControl segmentControl() {
        return HlsSegmentControl.fromValue(this.segmentControl);
    }

    public String segmentControlString() {
        return this.segmentControl;
    }

    public Integer segmentLength() {
        return this.segmentLength;
    }

    public Integer segmentsPerSubdirectory() {
        return this.segmentsPerSubdirectory;
    }

    public HlsStreamInfResolution streamInfResolution() {
        return HlsStreamInfResolution.fromValue(this.streamInfResolution);
    }

    public String streamInfResolutionString() {
        return this.streamInfResolution;
    }

    public HlsTimedMetadataId3Frame timedMetadataId3Frame() {
        return HlsTimedMetadataId3Frame.fromValue(this.timedMetadataId3Frame);
    }

    public String timedMetadataId3FrameString() {
        return this.timedMetadataId3Frame;
    }

    public Integer timedMetadataId3Period() {
        return this.timedMetadataId3Period;
    }

    public Integer timestampDeltaMilliseconds() {
        return this.timestampDeltaMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adMarkersStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionLanguageMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionLanguageSettingString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCacheString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSpecificationString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryStructureString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestCompressionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestDurationFormatString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSelectionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programDateTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentsPerSubdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfResolutionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3FrameString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataId3Period());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampDeltaMilliseconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings)obj;
        return Objects.equals(this.adMarkersStrings(), other.adMarkersStrings()) && Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.captionLanguageMappings(), other.captionLanguageMappings()) && Objects.equals(this.captionLanguageSettingString(), other.captionLanguageSettingString()) && Objects.equals(this.clientCacheString(), other.clientCacheString()) && Objects.equals(this.codecSpecificationString(), other.codecSpecificationString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.directoryStructureString(), other.directoryStructureString()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.manifestCompressionString(), other.manifestCompressionString()) && Objects.equals(this.manifestDurationFormatString(), other.manifestDurationFormatString()) && Objects.equals(this.minSegmentLength(), other.minSegmentLength()) && Objects.equals(this.outputSelectionString(), other.outputSelectionString()) && Objects.equals(this.programDateTimeString(), other.programDateTimeString()) && Objects.equals(this.programDateTimePeriod(), other.programDateTimePeriod()) && Objects.equals(this.segmentControlString(), other.segmentControlString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.segmentsPerSubdirectory(), other.segmentsPerSubdirectory()) && Objects.equals(this.streamInfResolutionString(), other.streamInfResolutionString()) && Objects.equals(this.timedMetadataId3FrameString(), other.timedMetadataId3FrameString()) && Objects.equals(this.timedMetadataId3Period(), other.timedMetadataId3Period()) && Objects.equals(this.timestampDeltaMilliseconds(), other.timestampDeltaMilliseconds());
    }

    public String toString() {
        return ToString.builder((String)"HlsGroupSettings").add("AdMarkers", this.adMarkersStrings()).add("BaseUrl", (Object)this.baseUrl()).add("CaptionLanguageMappings", this.captionLanguageMappings()).add("CaptionLanguageSetting", (Object)this.captionLanguageSettingString()).add("ClientCache", (Object)this.clientCacheString()).add("CodecSpecification", (Object)this.codecSpecificationString()).add("Destination", (Object)this.destination()).add("DirectoryStructure", (Object)this.directoryStructureString()).add("Encryption", (Object)this.encryption()).add("ManifestCompression", (Object)this.manifestCompressionString()).add("ManifestDurationFormat", (Object)this.manifestDurationFormatString()).add("MinSegmentLength", (Object)this.minSegmentLength()).add("OutputSelection", (Object)this.outputSelectionString()).add("ProgramDateTime", (Object)this.programDateTimeString()).add("ProgramDateTimePeriod", (Object)this.programDateTimePeriod()).add("SegmentControl", (Object)this.segmentControlString()).add("SegmentLength", (Object)this.segmentLength()).add("SegmentsPerSubdirectory", (Object)this.segmentsPerSubdirectory()).add("StreamInfResolution", (Object)this.streamInfResolutionString()).add("TimedMetadataId3Frame", (Object)this.timedMetadataId3FrameString()).add("TimedMetadataId3Period", (Object)this.timedMetadataId3Period()).add("TimestampDeltaMilliseconds", (Object)this.timestampDeltaMilliseconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.of(clazz.cast(this.adMarkersStrings()));
            }
            case "BaseUrl": {
                return Optional.of(clazz.cast(this.baseUrl()));
            }
            case "CaptionLanguageMappings": {
                return Optional.of(clazz.cast(this.captionLanguageMappings()));
            }
            case "CaptionLanguageSetting": {
                return Optional.of(clazz.cast(this.captionLanguageSettingString()));
            }
            case "ClientCache": {
                return Optional.of(clazz.cast(this.clientCacheString()));
            }
            case "CodecSpecification": {
                return Optional.of(clazz.cast(this.codecSpecificationString()));
            }
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
            case "DirectoryStructure": {
                return Optional.of(clazz.cast(this.directoryStructureString()));
            }
            case "Encryption": {
                return Optional.of(clazz.cast(this.encryption()));
            }
            case "ManifestCompression": {
                return Optional.of(clazz.cast(this.manifestCompressionString()));
            }
            case "ManifestDurationFormat": {
                return Optional.of(clazz.cast(this.manifestDurationFormatString()));
            }
            case "MinSegmentLength": {
                return Optional.of(clazz.cast(this.minSegmentLength()));
            }
            case "OutputSelection": {
                return Optional.of(clazz.cast(this.outputSelectionString()));
            }
            case "ProgramDateTime": {
                return Optional.of(clazz.cast(this.programDateTimeString()));
            }
            case "ProgramDateTimePeriod": {
                return Optional.of(clazz.cast(this.programDateTimePeriod()));
            }
            case "SegmentControl": {
                return Optional.of(clazz.cast(this.segmentControlString()));
            }
            case "SegmentLength": {
                return Optional.of(clazz.cast(this.segmentLength()));
            }
            case "SegmentsPerSubdirectory": {
                return Optional.of(clazz.cast(this.segmentsPerSubdirectory()));
            }
            case "StreamInfResolution": {
                return Optional.of(clazz.cast(this.streamInfResolutionString()));
            }
            case "TimedMetadataId3Frame": {
                return Optional.of(clazz.cast(this.timedMetadataId3FrameString()));
            }
            case "TimedMetadataId3Period": {
                return Optional.of(clazz.cast(this.timedMetadataId3Period()));
            }
            case "TimestampDeltaMilliseconds": {
                return Optional.of(clazz.cast(this.timestampDeltaMilliseconds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> adMarkers;
        private String baseUrl;
        private List<HlsCaptionLanguageMapping> captionLanguageMappings;
        private String captionLanguageSetting;
        private String clientCache;
        private String codecSpecification;
        private String destination;
        private String directoryStructure;
        private HlsEncryptionSettings encryption;
        private String manifestCompression;
        private String manifestDurationFormat;
        private Integer minSegmentLength;
        private String outputSelection;
        private String programDateTime;
        private Integer programDateTimePeriod;
        private String segmentControl;
        private Integer segmentLength;
        private Integer segmentsPerSubdirectory;
        private String streamInfResolution;
        private String timedMetadataId3Frame;
        private Integer timedMetadataId3Period;
        private Integer timestampDeltaMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsGroupSettings model) {
            this.adMarkers(model.adMarkers);
            this.baseUrl(model.baseUrl);
            this.captionLanguageMappings(model.captionLanguageMappings);
            this.captionLanguageSetting(model.captionLanguageSetting);
            this.clientCache(model.clientCache);
            this.codecSpecification(model.codecSpecification);
            this.destination(model.destination);
            this.directoryStructure(model.directoryStructure);
            this.encryption(model.encryption);
            this.manifestCompression(model.manifestCompression);
            this.manifestDurationFormat(model.manifestDurationFormat);
            this.minSegmentLength(model.minSegmentLength);
            this.outputSelection(model.outputSelection);
            this.programDateTime(model.programDateTime);
            this.programDateTimePeriod(model.programDateTimePeriod);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
            this.segmentsPerSubdirectory(model.segmentsPerSubdirectory);
            this.streamInfResolution(model.streamInfResolution);
            this.timedMetadataId3Frame(model.timedMetadataId3Frame);
            this.timedMetadataId3Period(model.timedMetadataId3Period);
            this.timestampDeltaMilliseconds(model.timestampDeltaMilliseconds);
        }

        public final Collection<String> getAdMarkers() {
            return this.adMarkers;
        }

        @Override
        public final Builder adMarkers(Collection<String> adMarkers) {
            this.adMarkers = ListOfHlsAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkers(String ... adMarkers) {
            this.adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final void setAdMarkers(Collection<String> adMarkers) {
            this.adMarkers = ListOfHlsAdMarkersCopier.copy(adMarkers);
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public final Collection<HlsCaptionLanguageMapping.Builder> getCaptionLanguageMappings() {
            return this.captionLanguageMappings != null ? (Collection)this.captionLanguageMappings.stream().map(HlsCaptionLanguageMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> captionLanguageMappings) {
            this.captionLanguageMappings = ListOfHlsCaptionLanguageMappingCopier.copy(captionLanguageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(HlsCaptionLanguageMapping ... captionLanguageMappings) {
            this.captionLanguageMappings(Arrays.asList(captionLanguageMappings));
            return this;
        }

        public final void setCaptionLanguageMappings(Collection<HlsCaptionLanguageMapping.BuilderImpl> captionLanguageMappings) {
            this.captionLanguageMappings = ListOfHlsCaptionLanguageMappingCopier.copyFromBuilder(captionLanguageMappings);
        }

        public final String getCaptionLanguageSetting() {
            return this.captionLanguageSetting;
        }

        @Override
        public final Builder captionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
            return this;
        }

        @Override
        public final Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
            this.captionLanguageSetting(captionLanguageSetting.toString());
            return this;
        }

        public final void setCaptionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
        }

        public final String getClientCache() {
            return this.clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(HlsClientCache clientCache) {
            this.clientCache(clientCache.toString());
            return this;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        public final String getCodecSpecification() {
            return this.codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(HlsCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification.toString());
            return this;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final String getDirectoryStructure() {
            return this.directoryStructure;
        }

        @Override
        public final Builder directoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
            return this;
        }

        @Override
        public final Builder directoryStructure(HlsDirectoryStructure directoryStructure) {
            this.directoryStructure(directoryStructure.toString());
            return this;
        }

        public final void setDirectoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
        }

        public final HlsEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(HlsEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(HlsEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getManifestCompression() {
            return this.manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(HlsManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression.toString());
            return this;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        public final String getManifestDurationFormat() {
            return this.manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat.toString());
            return this;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        public final Integer getMinSegmentLength() {
            return this.minSegmentLength;
        }

        @Override
        public final Builder minSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
            return this;
        }

        public final void setMinSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
        }

        public final String getOutputSelection() {
            return this.outputSelection;
        }

        @Override
        public final Builder outputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
            return this;
        }

        @Override
        public final Builder outputSelection(HlsOutputSelection outputSelection) {
            this.outputSelection(outputSelection.toString());
            return this;
        }

        public final void setOutputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
        }

        public final String getProgramDateTime() {
            return this.programDateTime;
        }

        @Override
        public final Builder programDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
            return this;
        }

        @Override
        public final Builder programDateTime(HlsProgramDateTime programDateTime) {
            this.programDateTime(programDateTime.toString());
            return this;
        }

        public final void setProgramDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
        }

        public final Integer getProgramDateTimePeriod() {
            return this.programDateTimePeriod;
        }

        @Override
        public final Builder programDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
            return this;
        }

        public final void setProgramDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
        }

        public final String getSegmentControl() {
            return this.segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(HlsSegmentControl segmentControl) {
            this.segmentControl(segmentControl.toString());
            return this;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final Integer getSegmentsPerSubdirectory() {
            return this.segmentsPerSubdirectory;
        }

        @Override
        public final Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
            return this;
        }

        public final void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
        }

        public final String getStreamInfResolution() {
            return this.streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(HlsStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution.toString());
            return this;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        public final String getTimedMetadataId3Frame() {
            return this.timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame.toString());
            return this;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        public final Integer getTimedMetadataId3Period() {
            return this.timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        public final Integer getTimestampDeltaMilliseconds() {
            return this.timestampDeltaMilliseconds;
        }

        @Override
        public final Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
            return this;
        }

        public final void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
        }

        public HlsGroupSettings build() {
            return new HlsGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsGroupSettings> {
        public Builder adMarkers(Collection<String> var1);

        public Builder adMarkers(String ... var1);

        public Builder baseUrl(String var1);

        public Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> var1);

        public Builder captionLanguageMappings(HlsCaptionLanguageMapping ... var1);

        public Builder captionLanguageSetting(String var1);

        public Builder captionLanguageSetting(HlsCaptionLanguageSetting var1);

        public Builder clientCache(String var1);

        public Builder clientCache(HlsClientCache var1);

        public Builder codecSpecification(String var1);

        public Builder codecSpecification(HlsCodecSpecification var1);

        public Builder destination(String var1);

        public Builder directoryStructure(String var1);

        public Builder directoryStructure(HlsDirectoryStructure var1);

        public Builder encryption(HlsEncryptionSettings var1);

        default public Builder encryption(Consumer<HlsEncryptionSettings.Builder> encryption) {
            return this.encryption((HlsEncryptionSettings)((HlsEncryptionSettings.Builder)HlsEncryptionSettings.builder().apply(encryption)).build());
        }

        public Builder manifestCompression(String var1);

        public Builder manifestCompression(HlsManifestCompression var1);

        public Builder manifestDurationFormat(String var1);

        public Builder manifestDurationFormat(HlsManifestDurationFormat var1);

        public Builder minSegmentLength(Integer var1);

        public Builder outputSelection(String var1);

        public Builder outputSelection(HlsOutputSelection var1);

        public Builder programDateTime(String var1);

        public Builder programDateTime(HlsProgramDateTime var1);

        public Builder programDateTimePeriod(Integer var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(HlsSegmentControl var1);

        public Builder segmentLength(Integer var1);

        public Builder segmentsPerSubdirectory(Integer var1);

        public Builder streamInfResolution(String var1);

        public Builder streamInfResolution(HlsStreamInfResolution var1);

        public Builder timedMetadataId3Frame(String var1);

        public Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame var1);

        public Builder timedMetadataId3Period(Integer var1);

        public Builder timestampDeltaMilliseconds(Integer var1);
    }
}

