/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.H264AdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H264CodecLevel;
import software.amazon.awssdk.services.mediaconvert.model.H264CodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.H264EntropyEncoding;
import software.amazon.awssdk.services.mediaconvert.model.H264FieldEncoding;
import software.amazon.awssdk.services.mediaconvert.model.H264FlickerAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H264FramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.H264FramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.H264GopBReference;
import software.amazon.awssdk.services.mediaconvert.model.H264GopSizeUnits;
import software.amazon.awssdk.services.mediaconvert.model.H264InterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.H264ParControl;
import software.amazon.awssdk.services.mediaconvert.model.H264QualityTuningLevel;
import software.amazon.awssdk.services.mediaconvert.model.H264RateControlMode;
import software.amazon.awssdk.services.mediaconvert.model.H264RepeatPps;
import software.amazon.awssdk.services.mediaconvert.model.H264SceneChangeDetect;
import software.amazon.awssdk.services.mediaconvert.model.H264SlowPal;
import software.amazon.awssdk.services.mediaconvert.model.H264SpatialAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H264Syntax;
import software.amazon.awssdk.services.mediaconvert.model.H264Telecine;
import software.amazon.awssdk.services.mediaconvert.model.H264TemporalAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H264UnregisteredSeiTimecode;
import software.amazon.awssdk.services.mediaconvert.transform.H264SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class H264Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, H264Settings> {
    private final String adaptiveQuantization;
    private final Integer bitrate;
    private final String codecLevel;
    private final String codecProfile;
    private final String entropyEncoding;
    private final String fieldEncoding;
    private final String flickerAdaptiveQuantization;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String gopBReference;
    private final Integer gopClosedCadence;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final Integer hrdBufferInitialFillPercentage;
    private final Integer hrdBufferSize;
    private final String interlaceMode;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer numberBFramesBetweenReferenceFrames;
    private final Integer numberReferenceFrames;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String qualityTuningLevel;
    private final String rateControlMode;
    private final String repeatPps;
    private final String sceneChangeDetect;
    private final Integer slices;
    private final String slowPal;
    private final Integer softness;
    private final String spatialAdaptiveQuantization;
    private final String syntax;
    private final String telecine;
    private final String temporalAdaptiveQuantization;
    private final String unregisteredSeiTimecode;

    private H264Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.entropyEncoding = builder.entropyEncoding;
        this.fieldEncoding = builder.fieldEncoding;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.numberReferenceFrames = builder.numberReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.rateControlMode = builder.rateControlMode;
        this.repeatPps = builder.repeatPps;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.slowPal = builder.slowPal;
        this.softness = builder.softness;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.syntax = builder.syntax;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
        this.unregisteredSeiTimecode = builder.unregisteredSeiTimecode;
    }

    public H264AdaptiveQuantization adaptiveQuantization() {
        return H264AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public String adaptiveQuantizationString() {
        return this.adaptiveQuantization;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public H264CodecLevel codecLevel() {
        return H264CodecLevel.fromValue(this.codecLevel);
    }

    public String codecLevelString() {
        return this.codecLevel;
    }

    public H264CodecProfile codecProfile() {
        return H264CodecProfile.fromValue(this.codecProfile);
    }

    public String codecProfileString() {
        return this.codecProfile;
    }

    public H264EntropyEncoding entropyEncoding() {
        return H264EntropyEncoding.fromValue(this.entropyEncoding);
    }

    public String entropyEncodingString() {
        return this.entropyEncoding;
    }

    public H264FieldEncoding fieldEncoding() {
        return H264FieldEncoding.fromValue(this.fieldEncoding);
    }

    public String fieldEncodingString() {
        return this.fieldEncoding;
    }

    public H264FlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return H264FlickerAdaptiveQuantization.fromValue(this.flickerAdaptiveQuantization);
    }

    public String flickerAdaptiveQuantizationString() {
        return this.flickerAdaptiveQuantization;
    }

    public H264FramerateControl framerateControl() {
        return H264FramerateControl.fromValue(this.framerateControl);
    }

    public String framerateControlString() {
        return this.framerateControl;
    }

    public H264FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return H264FramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public String framerateConversionAlgorithmString() {
        return this.framerateConversionAlgorithm;
    }

    public Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public H264GopBReference gopBReference() {
        return H264GopBReference.fromValue(this.gopBReference);
    }

    public String gopBReferenceString() {
        return this.gopBReference;
    }

    public Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public Double gopSize() {
        return this.gopSize;
    }

    public H264GopSizeUnits gopSizeUnits() {
        return H264GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public String gopSizeUnitsString() {
        return this.gopSizeUnits;
    }

    public Integer hrdBufferInitialFillPercentage() {
        return this.hrdBufferInitialFillPercentage;
    }

    public Integer hrdBufferSize() {
        return this.hrdBufferSize;
    }

    public H264InterlaceMode interlaceMode() {
        return H264InterlaceMode.fromValue(this.interlaceMode);
    }

    public String interlaceModeString() {
        return this.interlaceMode;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Integer minIInterval() {
        return this.minIInterval;
    }

    public Integer numberBFramesBetweenReferenceFrames() {
        return this.numberBFramesBetweenReferenceFrames;
    }

    public Integer numberReferenceFrames() {
        return this.numberReferenceFrames;
    }

    public H264ParControl parControl() {
        return H264ParControl.fromValue(this.parControl);
    }

    public String parControlString() {
        return this.parControl;
    }

    public Integer parDenominator() {
        return this.parDenominator;
    }

    public Integer parNumerator() {
        return this.parNumerator;
    }

    public H264QualityTuningLevel qualityTuningLevel() {
        return H264QualityTuningLevel.fromValue(this.qualityTuningLevel);
    }

    public String qualityTuningLevelString() {
        return this.qualityTuningLevel;
    }

    public H264RateControlMode rateControlMode() {
        return H264RateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeString() {
        return this.rateControlMode;
    }

    public H264RepeatPps repeatPps() {
        return H264RepeatPps.fromValue(this.repeatPps);
    }

    public String repeatPpsString() {
        return this.repeatPps;
    }

    public H264SceneChangeDetect sceneChangeDetect() {
        return H264SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public String sceneChangeDetectString() {
        return this.sceneChangeDetect;
    }

    public Integer slices() {
        return this.slices;
    }

    public H264SlowPal slowPal() {
        return H264SlowPal.fromValue(this.slowPal);
    }

    public String slowPalString() {
        return this.slowPal;
    }

    public Integer softness() {
        return this.softness;
    }

    public H264SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return H264SpatialAdaptiveQuantization.fromValue(this.spatialAdaptiveQuantization);
    }

    public String spatialAdaptiveQuantizationString() {
        return this.spatialAdaptiveQuantization;
    }

    public H264Syntax syntax() {
        return H264Syntax.fromValue(this.syntax);
    }

    public String syntaxString() {
        return this.syntax;
    }

    public H264Telecine telecine() {
        return H264Telecine.fromValue(this.telecine);
    }

    public String telecineString() {
        return this.telecine;
    }

    public H264TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return H264TemporalAdaptiveQuantization.fromValue(this.temporalAdaptiveQuantization);
    }

    public String temporalAdaptiveQuantizationString() {
        return this.temporalAdaptiveQuantization;
    }

    public H264UnregisteredSeiTimecode unregisteredSeiTimecode() {
        return H264UnregisteredSeiTimecode.fromValue(this.unregisteredSeiTimecode);
    }

    public String unregisteredSeiTimecodeString() {
        return this.unregisteredSeiTimecode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecLevelString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entropyEncodingString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldEncodingString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flickerAdaptiveQuantizationString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopBReferenceString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityTuningLevelString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repeatPpsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slices());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalString());
        hashCode = 31 * hashCode + Objects.hashCode(this.softness());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialAdaptiveQuantizationString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syntaxString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalAdaptiveQuantizationString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unregisteredSeiTimecodeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264Settings)) {
            return false;
        }
        H264Settings other = (H264Settings)obj;
        return Objects.equals(this.adaptiveQuantizationString(), other.adaptiveQuantizationString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codecLevelString(), other.codecLevelString()) && Objects.equals(this.codecProfileString(), other.codecProfileString()) && Objects.equals(this.entropyEncodingString(), other.entropyEncodingString()) && Objects.equals(this.fieldEncodingString(), other.fieldEncodingString()) && Objects.equals(this.flickerAdaptiveQuantizationString(), other.flickerAdaptiveQuantizationString()) && Objects.equals(this.framerateControlString(), other.framerateControlString()) && Objects.equals(this.framerateConversionAlgorithmString(), other.framerateConversionAlgorithmString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopBReferenceString(), other.gopBReferenceString()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsString(), other.gopSizeUnitsString()) && Objects.equals(this.hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage()) && Objects.equals(this.hrdBufferSize(), other.hrdBufferSize()) && Objects.equals(this.interlaceModeString(), other.interlaceModeString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames()) && Objects.equals(this.numberReferenceFrames(), other.numberReferenceFrames()) && Objects.equals(this.parControlString(), other.parControlString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.qualityTuningLevelString(), other.qualityTuningLevelString()) && Objects.equals(this.rateControlModeString(), other.rateControlModeString()) && Objects.equals(this.repeatPpsString(), other.repeatPpsString()) && Objects.equals(this.sceneChangeDetectString(), other.sceneChangeDetectString()) && Objects.equals(this.slices(), other.slices()) && Objects.equals(this.slowPalString(), other.slowPalString()) && Objects.equals(this.softness(), other.softness()) && Objects.equals(this.spatialAdaptiveQuantizationString(), other.spatialAdaptiveQuantizationString()) && Objects.equals(this.syntaxString(), other.syntaxString()) && Objects.equals(this.telecineString(), other.telecineString()) && Objects.equals(this.temporalAdaptiveQuantizationString(), other.temporalAdaptiveQuantizationString()) && Objects.equals(this.unregisteredSeiTimecodeString(), other.unregisteredSeiTimecodeString());
    }

    public String toString() {
        return ToString.builder((String)"H264Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationString()).add("Bitrate", (Object)this.bitrate()).add("CodecLevel", (Object)this.codecLevelString()).add("CodecProfile", (Object)this.codecProfileString()).add("EntropyEncoding", (Object)this.entropyEncodingString()).add("FieldEncoding", (Object)this.fieldEncodingString()).add("FlickerAdaptiveQuantization", (Object)this.flickerAdaptiveQuantizationString()).add("FramerateControl", (Object)this.framerateControlString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopBReference", (Object)this.gopBReferenceString()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsString()).add("HrdBufferInitialFillPercentage", (Object)this.hrdBufferInitialFillPercentage()).add("HrdBufferSize", (Object)this.hrdBufferSize()).add("InterlaceMode", (Object)this.interlaceModeString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("NumberBFramesBetweenReferenceFrames", (Object)this.numberBFramesBetweenReferenceFrames()).add("NumberReferenceFrames", (Object)this.numberReferenceFrames()).add("ParControl", (Object)this.parControlString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("QualityTuningLevel", (Object)this.qualityTuningLevelString()).add("RateControlMode", (Object)this.rateControlModeString()).add("RepeatPps", (Object)this.repeatPpsString()).add("SceneChangeDetect", (Object)this.sceneChangeDetectString()).add("Slices", (Object)this.slices()).add("SlowPal", (Object)this.slowPalString()).add("Softness", (Object)this.softness()).add("SpatialAdaptiveQuantization", (Object)this.spatialAdaptiveQuantizationString()).add("Syntax", (Object)this.syntaxString()).add("Telecine", (Object)this.telecineString()).add("TemporalAdaptiveQuantization", (Object)this.temporalAdaptiveQuantizationString()).add("UnregisteredSeiTimecode", (Object)this.unregisteredSeiTimecodeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.of(clazz.cast(this.adaptiveQuantizationString()));
            }
            case "Bitrate": {
                return Optional.of(clazz.cast(this.bitrate()));
            }
            case "CodecLevel": {
                return Optional.of(clazz.cast(this.codecLevelString()));
            }
            case "CodecProfile": {
                return Optional.of(clazz.cast(this.codecProfileString()));
            }
            case "EntropyEncoding": {
                return Optional.of(clazz.cast(this.entropyEncodingString()));
            }
            case "FieldEncoding": {
                return Optional.of(clazz.cast(this.fieldEncodingString()));
            }
            case "FlickerAdaptiveQuantization": {
                return Optional.of(clazz.cast(this.flickerAdaptiveQuantizationString()));
            }
            case "FramerateControl": {
                return Optional.of(clazz.cast(this.framerateControlString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.of(clazz.cast(this.framerateConversionAlgorithmString()));
            }
            case "FramerateDenominator": {
                return Optional.of(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.of(clazz.cast(this.framerateNumerator()));
            }
            case "GopBReference": {
                return Optional.of(clazz.cast(this.gopBReferenceString()));
            }
            case "GopClosedCadence": {
                return Optional.of(clazz.cast(this.gopClosedCadence()));
            }
            case "GopSize": {
                return Optional.of(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.of(clazz.cast(this.gopSizeUnitsString()));
            }
            case "HrdBufferInitialFillPercentage": {
                return Optional.of(clazz.cast(this.hrdBufferInitialFillPercentage()));
            }
            case "HrdBufferSize": {
                return Optional.of(clazz.cast(this.hrdBufferSize()));
            }
            case "InterlaceMode": {
                return Optional.of(clazz.cast(this.interlaceModeString()));
            }
            case "MaxBitrate": {
                return Optional.of(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.of(clazz.cast(this.minIInterval()));
            }
            case "NumberBFramesBetweenReferenceFrames": {
                return Optional.of(clazz.cast(this.numberBFramesBetweenReferenceFrames()));
            }
            case "NumberReferenceFrames": {
                return Optional.of(clazz.cast(this.numberReferenceFrames()));
            }
            case "ParControl": {
                return Optional.of(clazz.cast(this.parControlString()));
            }
            case "ParDenominator": {
                return Optional.of(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.of(clazz.cast(this.parNumerator()));
            }
            case "QualityTuningLevel": {
                return Optional.of(clazz.cast(this.qualityTuningLevelString()));
            }
            case "RateControlMode": {
                return Optional.of(clazz.cast(this.rateControlModeString()));
            }
            case "RepeatPps": {
                return Optional.of(clazz.cast(this.repeatPpsString()));
            }
            case "SceneChangeDetect": {
                return Optional.of(clazz.cast(this.sceneChangeDetectString()));
            }
            case "Slices": {
                return Optional.of(clazz.cast(this.slices()));
            }
            case "SlowPal": {
                return Optional.of(clazz.cast(this.slowPalString()));
            }
            case "Softness": {
                return Optional.of(clazz.cast(this.softness()));
            }
            case "SpatialAdaptiveQuantization": {
                return Optional.of(clazz.cast(this.spatialAdaptiveQuantizationString()));
            }
            case "Syntax": {
                return Optional.of(clazz.cast(this.syntaxString()));
            }
            case "Telecine": {
                return Optional.of(clazz.cast(this.telecineString()));
            }
            case "TemporalAdaptiveQuantization": {
                return Optional.of(clazz.cast(this.temporalAdaptiveQuantizationString()));
            }
            case "UnregisteredSeiTimecode": {
                return Optional.of(clazz.cast(this.unregisteredSeiTimecodeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        H264SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private Integer bitrate;
        private String codecLevel;
        private String codecProfile;
        private String entropyEncoding;
        private String fieldEncoding;
        private String flickerAdaptiveQuantization;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String gopBReference;
        private Integer gopClosedCadence;
        private Double gopSize;
        private String gopSizeUnits;
        private Integer hrdBufferInitialFillPercentage;
        private Integer hrdBufferSize;
        private String interlaceMode;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer numberBFramesBetweenReferenceFrames;
        private Integer numberReferenceFrames;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private String qualityTuningLevel;
        private String rateControlMode;
        private String repeatPps;
        private String sceneChangeDetect;
        private Integer slices;
        private String slowPal;
        private Integer softness;
        private String spatialAdaptiveQuantization;
        private String syntax;
        private String telecine;
        private String temporalAdaptiveQuantization;
        private String unregisteredSeiTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(H264Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.bitrate(model.bitrate);
            this.codecLevel(model.codecLevel);
            this.codecProfile(model.codecProfile);
            this.entropyEncoding(model.entropyEncoding);
            this.fieldEncoding(model.fieldEncoding);
            this.flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopBReference(model.gopBReference);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            this.hrdBufferSize(model.hrdBufferSize);
            this.interlaceMode(model.interlaceMode);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            this.numberReferenceFrames(model.numberReferenceFrames);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.qualityTuningLevel(model.qualityTuningLevel);
            this.rateControlMode(model.rateControlMode);
            this.repeatPps(model.repeatPps);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.slices(model.slices);
            this.slowPal(model.slowPal);
            this.softness(model.softness);
            this.spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            this.syntax(model.syntax);
            this.telecine(model.telecine);
            this.temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
            this.unregisteredSeiTimecode(model.unregisteredSeiTimecode);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H264AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecLevel() {
            return this.codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(H264CodecLevel codecLevel) {
            this.codecLevel(codecLevel.toString());
            return this;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        public final String getCodecProfile() {
            return this.codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(H264CodecProfile codecProfile) {
            this.codecProfile(codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getEntropyEncoding() {
            return this.entropyEncoding;
        }

        @Override
        public final Builder entropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
            return this;
        }

        @Override
        public final Builder entropyEncoding(H264EntropyEncoding entropyEncoding) {
            this.entropyEncoding(entropyEncoding.toString());
            return this;
        }

        public final void setEntropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
        }

        public final String getFieldEncoding() {
            return this.fieldEncoding;
        }

        @Override
        public final Builder fieldEncoding(String fieldEncoding) {
            this.fieldEncoding = fieldEncoding;
            return this;
        }

        @Override
        public final Builder fieldEncoding(H264FieldEncoding fieldEncoding) {
            this.fieldEncoding(fieldEncoding.toString());
            return this;
        }

        public final void setFieldEncoding(String fieldEncoding) {
            this.fieldEncoding = fieldEncoding;
        }

        public final String getFlickerAdaptiveQuantization() {
            return this.flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(H264FlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization.toString());
            return this;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(H264FramerateControl framerateControl) {
            this.framerateControl(framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(H264FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getGopBReference() {
            return this.gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H264GopBReference gopBReference) {
            this.gopBReference(gopBReference.toString());
            return this;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H264GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits.toString());
            return this;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return this.hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        public final Integer getHrdBufferSize() {
            return this.hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(H264InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return this.numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final Integer getNumberReferenceFrames() {
            return this.numberReferenceFrames;
        }

        @Override
        public final Builder numberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
            return this;
        }

        public final void setNumberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
        }

        public final String getParControl() {
            return this.parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(H264ParControl parControl) {
            this.parControl(parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getQualityTuningLevel() {
            return this.qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(H264QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel.toString());
            return this;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H264RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getRepeatPps() {
            return this.repeatPps;
        }

        @Override
        public final Builder repeatPps(String repeatPps) {
            this.repeatPps = repeatPps;
            return this;
        }

        @Override
        public final Builder repeatPps(H264RepeatPps repeatPps) {
            this.repeatPps(repeatPps.toString());
            return this;
        }

        public final void setRepeatPps(String repeatPps) {
            this.repeatPps = repeatPps;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H264SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect.toString());
            return this;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        public final Integer getSlices() {
            return this.slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(H264SlowPal slowPal) {
            this.slowPal(slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final Integer getSoftness() {
            return this.softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        public final String getSpatialAdaptiveQuantization() {
            return this.spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(H264SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        public final String getSyntax() {
            return this.syntax;
        }

        @Override
        public final Builder syntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        @Override
        public final Builder syntax(H264Syntax syntax) {
            this.syntax(syntax.toString());
            return this;
        }

        public final void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(H264Telecine telecine) {
            this.telecine(telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getTemporalAdaptiveQuantization() {
            return this.temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(H264TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization.toString());
            return this;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        public final String getUnregisteredSeiTimecode() {
            return this.unregisteredSeiTimecode;
        }

        @Override
        public final Builder unregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
            return this;
        }

        @Override
        public final Builder unregisteredSeiTimecode(H264UnregisteredSeiTimecode unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode(unregisteredSeiTimecode.toString());
            return this;
        }

        public final void setUnregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
        }

        public H264Settings build() {
            return new H264Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, H264Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(H264AdaptiveQuantization var1);

        public Builder bitrate(Integer var1);

        public Builder codecLevel(String var1);

        public Builder codecLevel(H264CodecLevel var1);

        public Builder codecProfile(String var1);

        public Builder codecProfile(H264CodecProfile var1);

        public Builder entropyEncoding(String var1);

        public Builder entropyEncoding(H264EntropyEncoding var1);

        public Builder fieldEncoding(String var1);

        public Builder fieldEncoding(H264FieldEncoding var1);

        public Builder flickerAdaptiveQuantization(String var1);

        public Builder flickerAdaptiveQuantization(H264FlickerAdaptiveQuantization var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(H264FramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(H264FramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopBReference(String var1);

        public Builder gopBReference(H264GopBReference var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(H264GopSizeUnits var1);

        public Builder hrdBufferInitialFillPercentage(Integer var1);

        public Builder hrdBufferSize(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(H264InterlaceMode var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder numberBFramesBetweenReferenceFrames(Integer var1);

        public Builder numberReferenceFrames(Integer var1);

        public Builder parControl(String var1);

        public Builder parControl(H264ParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder qualityTuningLevel(String var1);

        public Builder qualityTuningLevel(H264QualityTuningLevel var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(H264RateControlMode var1);

        public Builder repeatPps(String var1);

        public Builder repeatPps(H264RepeatPps var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(H264SceneChangeDetect var1);

        public Builder slices(Integer var1);

        public Builder slowPal(String var1);

        public Builder slowPal(H264SlowPal var1);

        public Builder softness(Integer var1);

        public Builder spatialAdaptiveQuantization(String var1);

        public Builder spatialAdaptiveQuantization(H264SpatialAdaptiveQuantization var1);

        public Builder syntax(String var1);

        public Builder syntax(H264Syntax var1);

        public Builder telecine(String var1);

        public Builder telecine(H264Telecine var1);

        public Builder temporalAdaptiveQuantization(String var1);

        public Builder temporalAdaptiveQuantization(H264TemporalAdaptiveQuantization var1);

        public Builder unregisteredSeiTimecode(String var1);

        public Builder unregisteredSeiTimecode(H264UnregisteredSeiTimecode var1);
    }
}

