/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.VideoDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VideoDetailMarshaller {
    private static final MarshallingInfo<Integer> HEIGHTINPX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("heightInPx").isBinary(false).build();
    private static final MarshallingInfo<Integer> WIDTHINPX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("widthInPx").isBinary(false).build();
    private static final VideoDetailMarshaller INSTANCE = new VideoDetailMarshaller();

    private VideoDetailMarshaller() {
    }

    public static VideoDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoDetail videoDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)videoDetail, (String)"videoDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)videoDetail.heightInPx(), HEIGHTINPX_BINDING);
            protocolMarshaller.marshall((Object)videoDetail.widthInPx(), WIDTHINPX_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

