/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.SccDestinationSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SccDestinationSettingsMarshaller {
    private static final MarshallingInfo<String> FRAMERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerate").isBinary(false).build();
    private static final SccDestinationSettingsMarshaller INSTANCE = new SccDestinationSettingsMarshaller();

    private SccDestinationSettingsMarshaller() {
    }

    public static SccDestinationSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SccDestinationSettings sccDestinationSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sccDestinationSettings, (String)"sccDestinationSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sccDestinationSettings.framerateAsString(), FRAMERATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

