/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothGroupSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MsSmoothGroupSettingsMarshaller {
    private static final MarshallingInfo<String> AUDIODEDUPLICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioDeduplication").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryption").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAGMENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fragmentLength").isBinary(false).build();
    private static final MarshallingInfo<String> MANIFESTENCODING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestEncoding").isBinary(false).build();
    private static final MsSmoothGroupSettingsMarshaller INSTANCE = new MsSmoothGroupSettingsMarshaller();

    private MsSmoothGroupSettingsMarshaller() {
    }

    public static MsSmoothGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MsSmoothGroupSettings msSmoothGroupSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)msSmoothGroupSettings, (String)"msSmoothGroupSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)msSmoothGroupSettings.audioDeduplicationAsString(), AUDIODEDUPLICATION_BINDING);
            protocolMarshaller.marshall((Object)msSmoothGroupSettings.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)msSmoothGroupSettings.encryption(), ENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)msSmoothGroupSettings.fragmentLength(), FRAGMENTLENGTH_BINDING);
            protocolMarshaller.marshall((Object)msSmoothGroupSettings.manifestEncodingAsString(), MANIFESTENCODING_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

