/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.H264Settings;
import software.amazon.awssdk.services.mediaconvert.transform.H264QvbrSettingsUnmarshaller;

public class H264SettingsUnmarshaller
implements Unmarshaller<H264Settings, JsonUnmarshallerContext> {
    private static final H264SettingsUnmarshaller INSTANCE = new H264SettingsUnmarshaller();

    public H264Settings unmarshall(JsonUnmarshallerContext context) throws Exception {
        H264Settings.Builder h264SettingsBuilder = H264Settings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("adaptiveQuantization", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.adaptiveQuantization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("bitrate", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.bitrate((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("codecLevel", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.codecLevel((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("codecProfile", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.codecProfile((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("dynamicSubGop", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.dynamicSubGop((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("entropyEncoding", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.entropyEncoding((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fieldEncoding", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.fieldEncoding((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("flickerAdaptiveQuantization", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.flickerAdaptiveQuantization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateControl", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.framerateControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateConversionAlgorithm", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.framerateConversionAlgorithm((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateDenominator", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.framerateDenominator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("framerateNumerator", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.framerateNumerator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopBReference", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.gopBReference((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopClosedCadence", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.gopClosedCadence((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopSize", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.gopSize((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("gopSizeUnits", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.gopSizeUnits((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hrdBufferInitialFillPercentage", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.hrdBufferInitialFillPercentage((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("hrdBufferSize", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.hrdBufferSize((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("interlaceMode", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.interlaceMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("maxBitrate", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.maxBitrate((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("minIInterval", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.minIInterval((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("numberBFramesBetweenReferenceFrames", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.numberBFramesBetweenReferenceFrames((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("numberReferenceFrames", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.numberReferenceFrames((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("parControl", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.parControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("parDenominator", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.parDenominator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("parNumerator", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.parNumerator((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("qualityTuningLevel", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.qualityTuningLevel((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("qvbrSettings", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.qvbrSettings(H264QvbrSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("rateControlMode", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.rateControlMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("repeatPps", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.repeatPps((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sceneChangeDetect", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.sceneChangeDetect((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("slices", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.slices((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("slowPal", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.slowPal((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("softness", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.softness((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("spatialAdaptiveQuantization", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.spatialAdaptiveQuantization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("syntax", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.syntax((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("telecine", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.telecine((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("temporalAdaptiveQuantization", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.temporalAdaptiveQuantization((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("unregisteredSeiTimecode", targetDepth)) {
                    context.nextToken();
                    h264SettingsBuilder.unregisteredSeiTimecode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (H264Settings)h264SettingsBuilder.build();
    }

    public static H264SettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

