/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.H264QvbrSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class H264QvbrSettingsMarshaller {
    private static final MarshallingInfo<Integer> MAXAVERAGEBITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxAverageBitrate").isBinary(false).build();
    private static final MarshallingInfo<Integer> QVBRQUALITYLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("qvbrQualityLevel").isBinary(false).build();
    private static final H264QvbrSettingsMarshaller INSTANCE = new H264QvbrSettingsMarshaller();

    private H264QvbrSettingsMarshaller() {
    }

    public static H264QvbrSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(H264QvbrSettings h264QvbrSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)h264QvbrSettings, (String)"h264QvbrSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)h264QvbrSettings.maxAverageBitrate(), MAXAVERAGEBITRATE_BINDING);
            protocolMarshaller.marshall((Object)h264QvbrSettings.qvbrQualityLevel(), QVBRQUALITYLEVEL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

