/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Deinterlacer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeinterlacerMarshaller {
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithm").isBinary(false).build();
    private static final MarshallingInfo<String> CONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("control").isBinary(false).build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mode").isBinary(false).build();
    private static final DeinterlacerMarshaller INSTANCE = new DeinterlacerMarshaller();

    private DeinterlacerMarshaller() {
    }

    public static DeinterlacerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Deinterlacer deinterlacer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deinterlacer, (String)"deinterlacer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deinterlacer.algorithmAsString(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)deinterlacer.controlAsString(), CONTROL_BINDING);
            protocolMarshaller.marshall((Object)deinterlacer.modeAsString(), MODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

