/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.ChannelMapping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ChannelMappingMarshaller {
    private static final MarshallingInfo<List> OUTPUTCHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputChannels").isBinary(false).build();
    private static final ChannelMappingMarshaller INSTANCE = new ChannelMappingMarshaller();

    private ChannelMappingMarshaller() {
    }

    public static ChannelMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ChannelMapping channelMapping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)channelMapping, (String)"channelMapping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(channelMapping.outputChannels(), OUTPUTCHANNELS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

