/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.AacSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AacSettingsMarshaller {
    private static final MarshallingInfo<String> AUDIODESCRIPTIONBROADCASTERMIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioDescriptionBroadcasterMix").isBinary(false).build();
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> CODECPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecProfile").isBinary(false).build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").isBinary(false).build();
    private static final MarshallingInfo<String> RATECONTROLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateControlMode").isBinary(false).build();
    private static final MarshallingInfo<String> RAWFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rawFormat").isBinary(false).build();
    private static final MarshallingInfo<Integer> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").isBinary(false).build();
    private static final MarshallingInfo<String> SPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("specification").isBinary(false).build();
    private static final MarshallingInfo<String> VBRQUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vbrQuality").isBinary(false).build();
    private static final AacSettingsMarshaller INSTANCE = new AacSettingsMarshaller();

    private AacSettingsMarshaller() {
    }

    public static AacSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AacSettings aacSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)aacSettings, (String)"aacSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)aacSettings.audioDescriptionBroadcasterMixAsString(), AUDIODESCRIPTIONBROADCASTERMIX_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.codecProfileAsString(), CODECPROFILE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.codingModeAsString(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.rateControlModeAsString(), RATECONTROLMODE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.rawFormatAsString(), RAWFORMAT_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.sampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.specificationAsString(), SPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)aacSettings.vbrQualityAsString(), VBRQUALITY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

