/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.___listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier;
import software.amazon.awssdk.services.mediaconvert.transform.SpekeKeyProviderMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpekeKeyProvider
implements StructuredPojo,
ToCopyableBuilder<Builder, SpekeKeyProvider> {
    private final String resourceId;
    private final List<String> systemIds;
    private final String url;

    private SpekeKeyProvider(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.systemIds = builder.systemIds;
        this.url = builder.url;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<String> systemIds() {
        return this.systemIds;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpekeKeyProvider)) {
            return false;
        }
        SpekeKeyProvider other = (SpekeKeyProvider)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.systemIds(), other.systemIds()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        return ToString.builder((String)"SpekeKeyProvider").add("ResourceId", (Object)this.resourceId()).add("SystemIds", this.systemIds()).add("Url", (Object)this.url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "SystemIds": {
                return Optional.ofNullable(clazz.cast(this.systemIds()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpekeKeyProviderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private List<String> systemIds = DefaultSdkAutoConstructList.getInstance();
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(SpekeKeyProvider model) {
            this.resourceId(model.resourceId);
            this.systemIds(model.systemIds);
            this.url(model.url);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<String> getSystemIds() {
            return this.systemIds;
        }

        @Override
        public final Builder systemIds(Collection<String> systemIds) {
            this.systemIds = ___listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier.copy(systemIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemIds(String ... systemIds) {
            this.systemIds(Arrays.asList(systemIds));
            return this;
        }

        public final void setSystemIds(Collection<String> systemIds) {
            this.systemIds = ___listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier.copy(systemIds);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public SpekeKeyProvider build() {
            return new SpekeKeyProvider(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpekeKeyProvider> {
        public Builder resourceId(String var1);

        public Builder systemIds(Collection<String> var1);

        public Builder systemIds(String ... var1);

        public Builder url(String var1);
    }
}

