/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.ChannelMapping;
import software.amazon.awssdk.services.mediaconvert.transform.RemixSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemixSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, RemixSettings> {
    private final ChannelMapping channelMapping;
    private final Integer channelsIn;
    private final Integer channelsOut;

    private RemixSettings(BuilderImpl builder) {
        this.channelMapping = builder.channelMapping;
        this.channelsIn = builder.channelsIn;
        this.channelsOut = builder.channelsOut;
    }

    public ChannelMapping channelMapping() {
        return this.channelMapping;
    }

    public Integer channelsIn() {
        return this.channelsIn;
    }

    public Integer channelsOut() {
        return this.channelsOut;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsOut());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemixSettings)) {
            return false;
        }
        RemixSettings other = (RemixSettings)obj;
        return Objects.equals(this.channelMapping(), other.channelMapping()) && Objects.equals(this.channelsIn(), other.channelsIn()) && Objects.equals(this.channelsOut(), other.channelsOut());
    }

    public String toString() {
        return ToString.builder((String)"RemixSettings").add("ChannelMapping", (Object)this.channelMapping()).add("ChannelsIn", (Object)this.channelsIn()).add("ChannelsOut", (Object)this.channelsOut()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelMapping": {
                return Optional.ofNullable(clazz.cast(this.channelMapping()));
            }
            case "ChannelsIn": {
                return Optional.ofNullable(clazz.cast(this.channelsIn()));
            }
            case "ChannelsOut": {
                return Optional.ofNullable(clazz.cast(this.channelsOut()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemixSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ChannelMapping channelMapping;
        private Integer channelsIn;
        private Integer channelsOut;

        private BuilderImpl() {
        }

        private BuilderImpl(RemixSettings model) {
            this.channelMapping(model.channelMapping);
            this.channelsIn(model.channelsIn);
            this.channelsOut(model.channelsOut);
        }

        public final ChannelMapping.Builder getChannelMapping() {
            return this.channelMapping != null ? this.channelMapping.toBuilder() : null;
        }

        @Override
        public final Builder channelMapping(ChannelMapping channelMapping) {
            this.channelMapping = channelMapping;
            return this;
        }

        public final void setChannelMapping(ChannelMapping.BuilderImpl channelMapping) {
            this.channelMapping = channelMapping != null ? channelMapping.build() : null;
        }

        public final Integer getChannelsIn() {
            return this.channelsIn;
        }

        @Override
        public final Builder channelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
            return this;
        }

        public final void setChannelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
        }

        public final Integer getChannelsOut() {
            return this.channelsOut;
        }

        @Override
        public final Builder channelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
            return this;
        }

        public final void setChannelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
        }

        public RemixSettings build() {
            return new RemixSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemixSettings> {
        public Builder channelMapping(ChannelMapping var1);

        default public Builder channelMapping(Consumer<ChannelMapping.Builder> channelMapping) {
            return this.channelMapping((ChannelMapping)((ChannelMapping.Builder)ChannelMapping.builder().applyMutation(channelMapping)).build());
        }

        public Builder channelsIn(Integer var1);

        public Builder channelsOut(Integer var1);
    }
}

