/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2AdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2CodecLevel;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2CodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2DynamicSubGop;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2FramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2FramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2GopSizeUnits;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2InterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2IntraDcPrecision;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2ParControl;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2QualityTuningLevel;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2RateControlMode;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2SceneChangeDetect;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2SlowPal;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2SpatialAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2Syntax;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2Telecine;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2TemporalAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.transform.Mpeg2SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mpeg2Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, Mpeg2Settings> {
    private final String adaptiveQuantization;
    private final Integer bitrate;
    private final String codecLevel;
    private final String codecProfile;
    private final String dynamicSubGop;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final Integer gopClosedCadence;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final Integer hrdBufferInitialFillPercentage;
    private final Integer hrdBufferSize;
    private final String interlaceMode;
    private final String intraDcPrecision;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer numberBFramesBetweenReferenceFrames;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String qualityTuningLevel;
    private final String rateControlMode;
    private final String sceneChangeDetect;
    private final String slowPal;
    private final Integer softness;
    private final String spatialAdaptiveQuantization;
    private final String syntax;
    private final String telecine;
    private final String temporalAdaptiveQuantization;

    private Mpeg2Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.dynamicSubGop = builder.dynamicSubGop;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.intraDcPrecision = builder.intraDcPrecision;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.rateControlMode = builder.rateControlMode;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slowPal = builder.slowPal;
        this.softness = builder.softness;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.syntax = builder.syntax;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
    }

    public Mpeg2AdaptiveQuantization adaptiveQuantization() {
        return Mpeg2AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public Mpeg2CodecLevel codecLevel() {
        return Mpeg2CodecLevel.fromValue(this.codecLevel);
    }

    public String codecLevelAsString() {
        return this.codecLevel;
    }

    public Mpeg2CodecProfile codecProfile() {
        return Mpeg2CodecProfile.fromValue(this.codecProfile);
    }

    public String codecProfileAsString() {
        return this.codecProfile;
    }

    public Mpeg2DynamicSubGop dynamicSubGop() {
        return Mpeg2DynamicSubGop.fromValue(this.dynamicSubGop);
    }

    public String dynamicSubGopAsString() {
        return this.dynamicSubGop;
    }

    public Mpeg2FramerateControl framerateControl() {
        return Mpeg2FramerateControl.fromValue(this.framerateControl);
    }

    public String framerateControlAsString() {
        return this.framerateControl;
    }

    public Mpeg2FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return Mpeg2FramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public Double gopSize() {
        return this.gopSize;
    }

    public Mpeg2GopSizeUnits gopSizeUnits() {
        return Mpeg2GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public Integer hrdBufferInitialFillPercentage() {
        return this.hrdBufferInitialFillPercentage;
    }

    public Integer hrdBufferSize() {
        return this.hrdBufferSize;
    }

    public Mpeg2InterlaceMode interlaceMode() {
        return Mpeg2InterlaceMode.fromValue(this.interlaceMode);
    }

    public String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public Mpeg2IntraDcPrecision intraDcPrecision() {
        return Mpeg2IntraDcPrecision.fromValue(this.intraDcPrecision);
    }

    public String intraDcPrecisionAsString() {
        return this.intraDcPrecision;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Integer minIInterval() {
        return this.minIInterval;
    }

    public Integer numberBFramesBetweenReferenceFrames() {
        return this.numberBFramesBetweenReferenceFrames;
    }

    public Mpeg2ParControl parControl() {
        return Mpeg2ParControl.fromValue(this.parControl);
    }

    public String parControlAsString() {
        return this.parControl;
    }

    public Integer parDenominator() {
        return this.parDenominator;
    }

    public Integer parNumerator() {
        return this.parNumerator;
    }

    public Mpeg2QualityTuningLevel qualityTuningLevel() {
        return Mpeg2QualityTuningLevel.fromValue(this.qualityTuningLevel);
    }

    public String qualityTuningLevelAsString() {
        return this.qualityTuningLevel;
    }

    public Mpeg2RateControlMode rateControlMode() {
        return Mpeg2RateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public Mpeg2SceneChangeDetect sceneChangeDetect() {
        return Mpeg2SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public String sceneChangeDetectAsString() {
        return this.sceneChangeDetect;
    }

    public Mpeg2SlowPal slowPal() {
        return Mpeg2SlowPal.fromValue(this.slowPal);
    }

    public String slowPalAsString() {
        return this.slowPal;
    }

    public Integer softness() {
        return this.softness;
    }

    public Mpeg2SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return Mpeg2SpatialAdaptiveQuantization.fromValue(this.spatialAdaptiveQuantization);
    }

    public String spatialAdaptiveQuantizationAsString() {
        return this.spatialAdaptiveQuantization;
    }

    public Mpeg2Syntax syntax() {
        return Mpeg2Syntax.fromValue(this.syntax);
    }

    public String syntaxAsString() {
        return this.syntax;
    }

    public Mpeg2Telecine telecine() {
        return Mpeg2Telecine.fromValue(this.telecine);
    }

    public String telecineAsString() {
        return this.telecine;
    }

    public Mpeg2TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return Mpeg2TemporalAdaptiveQuantization.fromValue(this.temporalAdaptiveQuantization);
    }

    public String temporalAdaptiveQuantizationAsString() {
        return this.temporalAdaptiveQuantization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicSubGopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.intraDcPrecisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.softness());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syntaxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalAdaptiveQuantizationAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mpeg2Settings)) {
            return false;
        }
        Mpeg2Settings other = (Mpeg2Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codecLevelAsString(), other.codecLevelAsString()) && Objects.equals(this.codecProfileAsString(), other.codecProfileAsString()) && Objects.equals(this.dynamicSubGopAsString(), other.dynamicSubGopAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage()) && Objects.equals(this.hrdBufferSize(), other.hrdBufferSize()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.intraDcPrecisionAsString(), other.intraDcPrecisionAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames()) && Objects.equals(this.parControlAsString(), other.parControlAsString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.qualityTuningLevelAsString(), other.qualityTuningLevelAsString()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.sceneChangeDetectAsString(), other.sceneChangeDetectAsString()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.softness(), other.softness()) && Objects.equals(this.spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString()) && Objects.equals(this.syntaxAsString(), other.syntaxAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString()) && Objects.equals(this.temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString());
    }

    public String toString() {
        return ToString.builder((String)"Mpeg2Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("Bitrate", (Object)this.bitrate()).add("CodecLevel", (Object)this.codecLevelAsString()).add("CodecProfile", (Object)this.codecProfileAsString()).add("DynamicSubGop", (Object)this.dynamicSubGopAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("HrdBufferInitialFillPercentage", (Object)this.hrdBufferInitialFillPercentage()).add("HrdBufferSize", (Object)this.hrdBufferSize()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("IntraDcPrecision", (Object)this.intraDcPrecisionAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("NumberBFramesBetweenReferenceFrames", (Object)this.numberBFramesBetweenReferenceFrames()).add("ParControl", (Object)this.parControlAsString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("QualityTuningLevel", (Object)this.qualityTuningLevelAsString()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("SceneChangeDetect", (Object)this.sceneChangeDetectAsString()).add("SlowPal", (Object)this.slowPalAsString()).add("Softness", (Object)this.softness()).add("SpatialAdaptiveQuantization", (Object)this.spatialAdaptiveQuantizationAsString()).add("Syntax", (Object)this.syntaxAsString()).add("Telecine", (Object)this.telecineAsString()).add("TemporalAdaptiveQuantization", (Object)this.temporalAdaptiveQuantizationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "CodecLevel": {
                return Optional.ofNullable(clazz.cast(this.codecLevelAsString()));
            }
            case "CodecProfile": {
                return Optional.ofNullable(clazz.cast(this.codecProfileAsString()));
            }
            case "DynamicSubGop": {
                return Optional.ofNullable(clazz.cast(this.dynamicSubGopAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "HrdBufferInitialFillPercentage": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferInitialFillPercentage()));
            }
            case "HrdBufferSize": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferSize()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "IntraDcPrecision": {
                return Optional.ofNullable(clazz.cast(this.intraDcPrecisionAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.ofNullable(clazz.cast(this.minIInterval()));
            }
            case "NumberBFramesBetweenReferenceFrames": {
                return Optional.ofNullable(clazz.cast(this.numberBFramesBetweenReferenceFrames()));
            }
            case "ParControl": {
                return Optional.ofNullable(clazz.cast(this.parControlAsString()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "QualityTuningLevel": {
                return Optional.ofNullable(clazz.cast(this.qualityTuningLevelAsString()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "SceneChangeDetect": {
                return Optional.ofNullable(clazz.cast(this.sceneChangeDetectAsString()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "Softness": {
                return Optional.ofNullable(clazz.cast(this.softness()));
            }
            case "SpatialAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.spatialAdaptiveQuantizationAsString()));
            }
            case "Syntax": {
                return Optional.ofNullable(clazz.cast(this.syntaxAsString()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
            case "TemporalAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.temporalAdaptiveQuantizationAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Mpeg2SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private Integer bitrate;
        private String codecLevel;
        private String codecProfile;
        private String dynamicSubGop;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private Integer gopClosedCadence;
        private Double gopSize;
        private String gopSizeUnits;
        private Integer hrdBufferInitialFillPercentage;
        private Integer hrdBufferSize;
        private String interlaceMode;
        private String intraDcPrecision;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer numberBFramesBetweenReferenceFrames;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private String qualityTuningLevel;
        private String rateControlMode;
        private String sceneChangeDetect;
        private String slowPal;
        private Integer softness;
        private String spatialAdaptiveQuantization;
        private String syntax;
        private String telecine;
        private String temporalAdaptiveQuantization;

        private BuilderImpl() {
        }

        private BuilderImpl(Mpeg2Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.bitrate(model.bitrate);
            this.codecLevel(model.codecLevel);
            this.codecProfile(model.codecProfile);
            this.dynamicSubGop(model.dynamicSubGop);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            this.hrdBufferSize(model.hrdBufferSize);
            this.interlaceMode(model.interlaceMode);
            this.intraDcPrecision(model.intraDcPrecision);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.qualityTuningLevel(model.qualityTuningLevel);
            this.rateControlMode(model.rateControlMode);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.slowPal(model.slowPal);
            this.softness(model.softness);
            this.spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            this.syntax(model.syntax);
            this.telecine(model.telecine);
            this.temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(Mpeg2AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecLevel() {
            return this.codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(Mpeg2CodecLevel codecLevel) {
            this.codecLevel(codecLevel.toString());
            return this;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        public final String getCodecProfile() {
            return this.codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(Mpeg2CodecProfile codecProfile) {
            this.codecProfile(codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getDynamicSubGop() {
            return this.dynamicSubGop;
        }

        @Override
        public final Builder dynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
            return this;
        }

        @Override
        public final Builder dynamicSubGop(Mpeg2DynamicSubGop dynamicSubGop) {
            this.dynamicSubGop(dynamicSubGop.toString());
            return this;
        }

        public final void setDynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(Mpeg2FramerateControl framerateControl) {
            this.framerateControl(framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(Mpeg2FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(Mpeg2GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits.toString());
            return this;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return this.hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        public final Integer getHrdBufferSize() {
            return this.hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(Mpeg2InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final String getIntraDcPrecision() {
            return this.intraDcPrecision;
        }

        @Override
        public final Builder intraDcPrecision(String intraDcPrecision) {
            this.intraDcPrecision = intraDcPrecision;
            return this;
        }

        @Override
        public final Builder intraDcPrecision(Mpeg2IntraDcPrecision intraDcPrecision) {
            this.intraDcPrecision(intraDcPrecision.toString());
            return this;
        }

        public final void setIntraDcPrecision(String intraDcPrecision) {
            this.intraDcPrecision = intraDcPrecision;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return this.numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final String getParControl() {
            return this.parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(Mpeg2ParControl parControl) {
            this.parControl(parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getQualityTuningLevel() {
            return this.qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(Mpeg2QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel.toString());
            return this;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(Mpeg2RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(Mpeg2SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect.toString());
            return this;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(Mpeg2SlowPal slowPal) {
            this.slowPal(slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final Integer getSoftness() {
            return this.softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        public final String getSpatialAdaptiveQuantization() {
            return this.spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(Mpeg2SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        public final String getSyntax() {
            return this.syntax;
        }

        @Override
        public final Builder syntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        @Override
        public final Builder syntax(Mpeg2Syntax syntax) {
            this.syntax(syntax.toString());
            return this;
        }

        public final void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(Mpeg2Telecine telecine) {
            this.telecine(telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getTemporalAdaptiveQuantization() {
            return this.temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(Mpeg2TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization.toString());
            return this;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        public Mpeg2Settings build() {
            return new Mpeg2Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Mpeg2Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(Mpeg2AdaptiveQuantization var1);

        public Builder bitrate(Integer var1);

        public Builder codecLevel(String var1);

        public Builder codecLevel(Mpeg2CodecLevel var1);

        public Builder codecProfile(String var1);

        public Builder codecProfile(Mpeg2CodecProfile var1);

        public Builder dynamicSubGop(String var1);

        public Builder dynamicSubGop(Mpeg2DynamicSubGop var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(Mpeg2FramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(Mpeg2FramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(Mpeg2GopSizeUnits var1);

        public Builder hrdBufferInitialFillPercentage(Integer var1);

        public Builder hrdBufferSize(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(Mpeg2InterlaceMode var1);

        public Builder intraDcPrecision(String var1);

        public Builder intraDcPrecision(Mpeg2IntraDcPrecision var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder numberBFramesBetweenReferenceFrames(Integer var1);

        public Builder parControl(String var1);

        public Builder parControl(Mpeg2ParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder qualityTuningLevel(String var1);

        public Builder qualityTuningLevel(Mpeg2QualityTuningLevel var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(Mpeg2RateControlMode var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(Mpeg2SceneChangeDetect var1);

        public Builder slowPal(String var1);

        public Builder slowPal(Mpeg2SlowPal var1);

        public Builder softness(Integer var1);

        public Builder spatialAdaptiveQuantization(String var1);

        public Builder spatialAdaptiveQuantization(Mpeg2SpatialAdaptiveQuantization var1);

        public Builder syntax(String var1);

        public Builder syntax(Mpeg2Syntax var1);

        public Builder telecine(String var1);

        public Builder telecine(Mpeg2Telecine var1);

        public Builder temporalAdaptiveQuantization(String var1);

        public Builder temporalAdaptiveQuantization(Mpeg2TemporalAdaptiveQuantization var1);
    }
}

