/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.transform.Mp2SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mp2Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, Mp2Settings> {
    private final Integer bitrate;
    private final Integer channels;
    private final Integer sampleRate;

    private Mp2Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.channels = builder.channels;
        this.sampleRate = builder.sampleRate;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public Integer channels() {
        return this.channels;
    }

    public Integer sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp2Settings)) {
            return false;
        }
        Mp2Settings other = (Mp2Settings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public String toString() {
        return ToString.builder((String)"Mp2Settings").add("Bitrate", (Object)this.bitrate()).add("Channels", (Object)this.channels()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Mp2SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitrate;
        private Integer channels;
        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp2Settings model) {
            this.bitrate(model.bitrate);
            this.channels(model.channels);
            this.sampleRate(model.sampleRate);
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final Integer getChannels() {
            return this.channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public Mp2Settings build() {
            return new Mp2Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Mp2Settings> {
        public Builder bitrate(Integer var1);

        public Builder channels(Integer var1);

        public Builder sampleRate(Integer var1);
    }
}

