/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.JobTemplate;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertResponse;
import software.amazon.awssdk.services.mediaconvert.model.___listOfJobTemplateCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobTemplatesResponse
extends MediaConvertResponse
implements ToCopyableBuilder<Builder, ListJobTemplatesResponse> {
    private final List<JobTemplate> jobTemplates;
    private final String nextToken;

    private ListJobTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.jobTemplates = builder.jobTemplates;
        this.nextToken = builder.nextToken;
    }

    public List<JobTemplate> jobTemplates() {
        return this.jobTemplates;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobTemplatesResponse)) {
            return false;
        }
        ListJobTemplatesResponse other = (ListJobTemplatesResponse)((Object)obj);
        return Objects.equals(this.jobTemplates(), other.jobTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListJobTemplatesResponse").add("JobTemplates", this.jobTemplates()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobTemplates": {
                return Optional.ofNullable(clazz.cast(this.jobTemplates()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaConvertResponse.BuilderImpl
    implements Builder {
        private List<JobTemplate> jobTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobTemplatesResponse model) {
            super(model);
            this.jobTemplates(model.jobTemplates);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobTemplate.Builder> getJobTemplates() {
            return this.jobTemplates != null ? (Collection)this.jobTemplates.stream().map(JobTemplate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobTemplates(Collection<JobTemplate> jobTemplates) {
            this.jobTemplates = ___listOfJobTemplateCopier.copy(jobTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTemplates(JobTemplate ... jobTemplates) {
            this.jobTemplates(Arrays.asList(jobTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTemplates(Consumer<JobTemplate.Builder> ... jobTemplates) {
            this.jobTemplates(Stream.of(jobTemplates).map(c -> (JobTemplate)((JobTemplate.Builder)JobTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobTemplates(Collection<JobTemplate.BuilderImpl> jobTemplates) {
            this.jobTemplates = ___listOfJobTemplateCopier.copyFromBuilder(jobTemplates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobTemplatesResponse build() {
            return new ListJobTemplatesResponse(this);
        }
    }

    public static interface Builder
    extends MediaConvertResponse.Builder,
    CopyableBuilder<Builder, ListJobTemplatesResponse> {
        public Builder jobTemplates(Collection<JobTemplate> var1);

        public Builder jobTemplates(JobTemplate ... var1);

        public Builder jobTemplates(Consumer<JobTemplate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

