/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.OutputChannelMapping;
import software.amazon.awssdk.services.mediaconvert.model.___listOfOutputChannelMappingCopier;
import software.amazon.awssdk.services.mediaconvert.transform.ChannelMappingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, ChannelMapping> {
    private final List<OutputChannelMapping> outputChannels;

    private ChannelMapping(BuilderImpl builder) {
        this.outputChannels = builder.outputChannels;
    }

    public List<OutputChannelMapping> outputChannels() {
        return this.outputChannels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputChannels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMapping)) {
            return false;
        }
        ChannelMapping other = (ChannelMapping)obj;
        return Objects.equals(this.outputChannels(), other.outputChannels());
    }

    public String toString() {
        return ToString.builder((String)"ChannelMapping").add("OutputChannels", this.outputChannels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputChannels": {
                return Optional.ofNullable(clazz.cast(this.outputChannels()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<OutputChannelMapping> outputChannels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMapping model) {
            this.outputChannels(model.outputChannels);
        }

        public final Collection<OutputChannelMapping.Builder> getOutputChannels() {
            return this.outputChannels != null ? (Collection)this.outputChannels.stream().map(OutputChannelMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputChannels(Collection<OutputChannelMapping> outputChannels) {
            this.outputChannels = ___listOfOutputChannelMappingCopier.copy(outputChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputChannels(OutputChannelMapping ... outputChannels) {
            this.outputChannels(Arrays.asList(outputChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputChannels(Consumer<OutputChannelMapping.Builder> ... outputChannels) {
            this.outputChannels(Stream.of(outputChannels).map(c -> (OutputChannelMapping)((OutputChannelMapping.Builder)OutputChannelMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputChannels(Collection<OutputChannelMapping.BuilderImpl> outputChannels) {
            this.outputChannels = ___listOfOutputChannelMappingCopier.copyFromBuilder(outputChannels);
        }

        public ChannelMapping build() {
            return new ChannelMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChannelMapping> {
        public Builder outputChannels(Collection<OutputChannelMapping> var1);

        public Builder outputChannels(OutputChannelMapping ... var1);

        public Builder outputChannels(Consumer<OutputChannelMapping.Builder> ... var1);
    }
}

