/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AudioCodecSettings;
import software.amazon.awssdk.services.mediaconvert.model.AudioLanguageCodeControl;
import software.amazon.awssdk.services.mediaconvert.model.AudioNormalizationSettings;
import software.amazon.awssdk.services.mediaconvert.model.AudioTypeControl;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.services.mediaconvert.model.RemixSettings;
import software.amazon.awssdk.services.mediaconvert.transform.AudioDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioDescription> {
    private final AudioNormalizationSettings audioNormalizationSettings;
    private final String audioSourceName;
    private final Integer audioType;
    private final String audioTypeControl;
    private final AudioCodecSettings codecSettings;
    private final String customLanguageCode;
    private final String languageCode;
    private final String languageCodeControl;
    private final RemixSettings remixSettings;
    private final String streamName;

    private AudioDescription(BuilderImpl builder) {
        this.audioNormalizationSettings = builder.audioNormalizationSettings;
        this.audioSourceName = builder.audioSourceName;
        this.audioType = builder.audioType;
        this.audioTypeControl = builder.audioTypeControl;
        this.codecSettings = builder.codecSettings;
        this.customLanguageCode = builder.customLanguageCode;
        this.languageCode = builder.languageCode;
        this.languageCodeControl = builder.languageCodeControl;
        this.remixSettings = builder.remixSettings;
        this.streamName = builder.streamName;
    }

    public AudioNormalizationSettings audioNormalizationSettings() {
        return this.audioNormalizationSettings;
    }

    public String audioSourceName() {
        return this.audioSourceName;
    }

    public Integer audioType() {
        return this.audioType;
    }

    public AudioTypeControl audioTypeControl() {
        return AudioTypeControl.fromValue(this.audioTypeControl);
    }

    public String audioTypeControlAsString() {
        return this.audioTypeControl;
    }

    public AudioCodecSettings codecSettings() {
        return this.codecSettings;
    }

    public String customLanguageCode() {
        return this.customLanguageCode;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public AudioLanguageCodeControl languageCodeControl() {
        return AudioLanguageCodeControl.fromValue(this.languageCodeControl);
    }

    public String languageCodeControlAsString() {
        return this.languageCodeControl;
    }

    public RemixSettings remixSettings() {
        return this.remixSettings;
    }

    public String streamName() {
        return this.streamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioNormalizationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioType());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTypeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remixSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioDescription)) {
            return false;
        }
        AudioDescription other = (AudioDescription)obj;
        return Objects.equals(this.audioNormalizationSettings(), other.audioNormalizationSettings()) && Objects.equals(this.audioSourceName(), other.audioSourceName()) && Objects.equals(this.audioType(), other.audioType()) && Objects.equals(this.audioTypeControlAsString(), other.audioTypeControlAsString()) && Objects.equals(this.codecSettings(), other.codecSettings()) && Objects.equals(this.customLanguageCode(), other.customLanguageCode()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.languageCodeControlAsString(), other.languageCodeControlAsString()) && Objects.equals(this.remixSettings(), other.remixSettings()) && Objects.equals(this.streamName(), other.streamName());
    }

    public String toString() {
        return ToString.builder((String)"AudioDescription").add("AudioNormalizationSettings", (Object)this.audioNormalizationSettings()).add("AudioSourceName", (Object)this.audioSourceName()).add("AudioType", (Object)this.audioType()).add("AudioTypeControl", (Object)this.audioTypeControlAsString()).add("CodecSettings", (Object)this.codecSettings()).add("CustomLanguageCode", (Object)this.customLanguageCode()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LanguageCodeControl", (Object)this.languageCodeControlAsString()).add("RemixSettings", (Object)this.remixSettings()).add("StreamName", (Object)this.streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioNormalizationSettings": {
                return Optional.ofNullable(clazz.cast(this.audioNormalizationSettings()));
            }
            case "AudioSourceName": {
                return Optional.ofNullable(clazz.cast(this.audioSourceName()));
            }
            case "AudioType": {
                return Optional.ofNullable(clazz.cast(this.audioType()));
            }
            case "AudioTypeControl": {
                return Optional.ofNullable(clazz.cast(this.audioTypeControlAsString()));
            }
            case "CodecSettings": {
                return Optional.ofNullable(clazz.cast(this.codecSettings()));
            }
            case "CustomLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.customLanguageCode()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LanguageCodeControl": {
                return Optional.ofNullable(clazz.cast(this.languageCodeControlAsString()));
            }
            case "RemixSettings": {
                return Optional.ofNullable(clazz.cast(this.remixSettings()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioNormalizationSettings audioNormalizationSettings;
        private String audioSourceName;
        private Integer audioType;
        private String audioTypeControl;
        private AudioCodecSettings codecSettings;
        private String customLanguageCode;
        private String languageCode;
        private String languageCodeControl;
        private RemixSettings remixSettings;
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioDescription model) {
            this.audioNormalizationSettings(model.audioNormalizationSettings);
            this.audioSourceName(model.audioSourceName);
            this.audioType(model.audioType);
            this.audioTypeControl(model.audioTypeControl);
            this.codecSettings(model.codecSettings);
            this.customLanguageCode(model.customLanguageCode);
            this.languageCode(model.languageCode);
            this.languageCodeControl(model.languageCodeControl);
            this.remixSettings(model.remixSettings);
            this.streamName(model.streamName);
        }

        public final AudioNormalizationSettings.Builder getAudioNormalizationSettings() {
            return this.audioNormalizationSettings != null ? this.audioNormalizationSettings.toBuilder() : null;
        }

        @Override
        public final Builder audioNormalizationSettings(AudioNormalizationSettings audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings;
            return this;
        }

        public final void setAudioNormalizationSettings(AudioNormalizationSettings.BuilderImpl audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings != null ? audioNormalizationSettings.build() : null;
        }

        public final String getAudioSourceName() {
            return this.audioSourceName;
        }

        @Override
        public final Builder audioSourceName(String audioSourceName) {
            this.audioSourceName = audioSourceName;
            return this;
        }

        public final void setAudioSourceName(String audioSourceName) {
            this.audioSourceName = audioSourceName;
        }

        public final Integer getAudioType() {
            return this.audioType;
        }

        @Override
        public final Builder audioType(Integer audioType) {
            this.audioType = audioType;
            return this;
        }

        public final void setAudioType(Integer audioType) {
            this.audioType = audioType;
        }

        public final String getAudioTypeControl() {
            return this.audioTypeControl;
        }

        @Override
        public final Builder audioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
            return this;
        }

        @Override
        public final Builder audioTypeControl(AudioTypeControl audioTypeControl) {
            this.audioTypeControl(audioTypeControl.toString());
            return this;
        }

        public final void setAudioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
        }

        public final AudioCodecSettings.Builder getCodecSettings() {
            return this.codecSettings != null ? this.codecSettings.toBuilder() : null;
        }

        @Override
        public final Builder codecSettings(AudioCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final void setCodecSettings(AudioCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        public final String getCustomLanguageCode() {
            return this.customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageCodeControl() {
            return this.languageCodeControl;
        }

        @Override
        public final Builder languageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
            return this;
        }

        @Override
        public final Builder languageCodeControl(AudioLanguageCodeControl languageCodeControl) {
            this.languageCodeControl(languageCodeControl.toString());
            return this;
        }

        public final void setLanguageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
        }

        public final RemixSettings.Builder getRemixSettings() {
            return this.remixSettings != null ? this.remixSettings.toBuilder() : null;
        }

        @Override
        public final Builder remixSettings(RemixSettings remixSettings) {
            this.remixSettings = remixSettings;
            return this;
        }

        public final void setRemixSettings(RemixSettings.BuilderImpl remixSettings) {
            this.remixSettings = remixSettings != null ? remixSettings.build() : null;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public AudioDescription build() {
            return new AudioDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioDescription> {
        public Builder audioNormalizationSettings(AudioNormalizationSettings var1);

        default public Builder audioNormalizationSettings(Consumer<AudioNormalizationSettings.Builder> audioNormalizationSettings) {
            return this.audioNormalizationSettings((AudioNormalizationSettings)((AudioNormalizationSettings.Builder)AudioNormalizationSettings.builder().applyMutation(audioNormalizationSettings)).build());
        }

        public Builder audioSourceName(String var1);

        public Builder audioType(Integer var1);

        public Builder audioTypeControl(String var1);

        public Builder audioTypeControl(AudioTypeControl var1);

        public Builder codecSettings(AudioCodecSettings var1);

        default public Builder codecSettings(Consumer<AudioCodecSettings.Builder> codecSettings) {
            return this.codecSettings((AudioCodecSettings)((AudioCodecSettings.Builder)AudioCodecSettings.builder().applyMutation(codecSettings)).build());
        }

        public Builder customLanguageCode(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder languageCodeControl(String var1);

        public Builder languageCodeControl(AudioLanguageCodeControl var1);

        public Builder remixSettings(RemixSettings var1);

        default public Builder remixSettings(Consumer<RemixSettings.Builder> remixSettings) {
            return this.remixSettings((RemixSettings)((RemixSettings.Builder)RemixSettings.builder().applyMutation(remixSettings)).build());
        }

        public Builder streamName(String var1);
    }
}

