/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.VideoPreprocessor;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VideoPreprocessorMarshaller {
    private static final MarshallingInfo<StructuredPojo> COLORCORRECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorCorrector").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEINTERLACER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deinterlacer").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> IMAGEINSERTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageInserter").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOISEREDUCER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("noiseReducer").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMECODEBURNIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeBurnin").isBinary(false).build();
    private static final VideoPreprocessorMarshaller INSTANCE = new VideoPreprocessorMarshaller();

    private VideoPreprocessorMarshaller() {
    }

    public static VideoPreprocessorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoPreprocessor videoPreprocessor, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)videoPreprocessor, (String)"videoPreprocessor");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)videoPreprocessor.colorCorrector(), COLORCORRECTOR_BINDING);
            protocolMarshaller.marshall((Object)videoPreprocessor.deinterlacer(), DEINTERLACER_BINDING);
            protocolMarshaller.marshall((Object)videoPreprocessor.imageInserter(), IMAGEINSERTER_BINDING);
            protocolMarshaller.marshall((Object)videoPreprocessor.noiseReducer(), NOISEREDUCER_BINDING);
            protocolMarshaller.marshall((Object)videoPreprocessor.timecodeBurnin(), TIMECODEBURNIN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

