/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.VideoCodecSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VideoCodecSettingsMarshaller {
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codec").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FRAMECAPTURESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frameCaptureSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> H264SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("h264Settings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> H265SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("h265Settings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MPEG2SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mpeg2Settings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PRORESSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("proresSettings").isBinary(false).build();
    private static final VideoCodecSettingsMarshaller INSTANCE = new VideoCodecSettingsMarshaller();

    private VideoCodecSettingsMarshaller() {
    }

    public static VideoCodecSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoCodecSettings videoCodecSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)videoCodecSettings, (String)"videoCodecSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)videoCodecSettings.codecAsString(), CODEC_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.frameCaptureSettings(), FRAMECAPTURESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.h264Settings(), H264SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.h265Settings(), H265SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.mpeg2Settings(), MPEG2SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoCodecSettings.proresSettings(), PRORESSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

