/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.TimedMetadataInsertion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TimedMetadataInsertionMarshaller {
    private static final MarshallingInfo<List> ID3INSERTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id3Insertions").isBinary(false).build();
    private static final TimedMetadataInsertionMarshaller INSTANCE = new TimedMetadataInsertionMarshaller();

    private TimedMetadataInsertionMarshaller() {
    }

    public static TimedMetadataInsertionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TimedMetadataInsertion timedMetadataInsertion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)timedMetadataInsertion, (String)"timedMetadataInsertion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(timedMetadataInsertion.id3Insertions(), ID3INSERTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

