/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.RemixSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RemixSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> CHANNELMAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelMapping").isBinary(false).build();
    private static final MarshallingInfo<Integer> CHANNELSIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelsIn").isBinary(false).build();
    private static final MarshallingInfo<Integer> CHANNELSOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelsOut").isBinary(false).build();
    private static final RemixSettingsMarshaller INSTANCE = new RemixSettingsMarshaller();

    private RemixSettingsMarshaller() {
    }

    public static RemixSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RemixSettings remixSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)remixSettings, (String)"remixSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)remixSettings.channelMapping(), CHANNELMAPPING_BINDING);
            protocolMarshaller.marshall((Object)remixSettings.channelsIn(), CHANNELSIN_BINDING);
            protocolMarshaller.marshall((Object)remixSettings.channelsOut(), CHANNELSOUT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

