/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputGroupMarshaller {
    private static final MarshallingInfo<String> CUSTOMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customName").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTGROUPSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputGroupSettings").isBinary(false).build();
    private static final MarshallingInfo<List> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputs").isBinary(false).build();
    private static final OutputGroupMarshaller INSTANCE = new OutputGroupMarshaller();

    private OutputGroupMarshaller() {
    }

    public static OutputGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputGroup outputGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputGroup, (String)"outputGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputGroup.customName(), CUSTOMNAME_BINDING);
            protocolMarshaller.marshall((Object)outputGroup.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)outputGroup.outputGroupSettings(), OUTPUTGROUPSETTINGS_BINDING);
            protocolMarshaller.marshall(outputGroup.outputs(), OUTPUTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

