/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.OutputDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputDetailMarshaller {
    private static final MarshallingInfo<Integer> DURATIONINMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("durationInMs").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VIDEODETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoDetails").isBinary(false).build();
    private static final OutputDetailMarshaller INSTANCE = new OutputDetailMarshaller();

    private OutputDetailMarshaller() {
    }

    public static OutputDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutputDetail outputDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outputDetail, (String)"outputDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outputDetail.durationInMs(), DURATIONINMS_BINDING);
            protocolMarshaller.marshall((Object)outputDetail.videoDetails(), VIDEODETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

