/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Mpeg2SettingsMarshaller {
    private static final MarshallingInfo<String> ADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> CODECLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecLevel").isBinary(false).build();
    private static final MarshallingInfo<String> CODECPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecProfile").isBinary(false).build();
    private static final MarshallingInfo<String> FRAMERATECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateControl").isBinary(false).build();
    private static final MarshallingInfo<String> FRAMERATECONVERSIONALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateConversionAlgorithm").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATEDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATENUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateNumerator").isBinary(false).build();
    private static final MarshallingInfo<Integer> GOPCLOSEDCADENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopClosedCadence").isBinary(false).build();
    private static final MarshallingInfo<Double> GOPSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSize").isBinary(false).build();
    private static final MarshallingInfo<String> GOPSIZEUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSizeUnits").isBinary(false).build();
    private static final MarshallingInfo<Integer> HRDBUFFERINITIALFILLPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hrdBufferInitialFillPercentage").isBinary(false).build();
    private static final MarshallingInfo<Integer> HRDBUFFERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hrdBufferSize").isBinary(false).build();
    private static final MarshallingInfo<String> INTERLACEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("interlaceMode").isBinary(false).build();
    private static final MarshallingInfo<String> INTRADCPRECISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("intraDcPrecision").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXBITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxBitrate").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINIINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minIInterval").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMBERBFRAMESBETWEENREFERENCEFRAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numberBFramesBetweenReferenceFrames").isBinary(false).build();
    private static final MarshallingInfo<String> PARCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARNUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parNumerator").isBinary(false).build();
    private static final MarshallingInfo<String> QUALITYTUNINGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("qualityTuningLevel").isBinary(false).build();
    private static final MarshallingInfo<String> RATECONTROLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateControlMode").isBinary(false).build();
    private static final MarshallingInfo<String> SCENECHANGEDETECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sceneChangeDetect").isBinary(false).build();
    private static final MarshallingInfo<String> SLOWPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slowPal").isBinary(false).build();
    private static final MarshallingInfo<Integer> SOFTNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softness").isBinary(false).build();
    private static final MarshallingInfo<String> SPATIALADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spatialAdaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<String> SYNTAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("syntax").isBinary(false).build();
    private static final MarshallingInfo<String> TELECINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("telecine").isBinary(false).build();
    private static final MarshallingInfo<String> TEMPORALADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("temporalAdaptiveQuantization").isBinary(false).build();
    private static final Mpeg2SettingsMarshaller INSTANCE = new Mpeg2SettingsMarshaller();

    private Mpeg2SettingsMarshaller() {
    }

    public static Mpeg2SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Mpeg2Settings mpeg2Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mpeg2Settings, (String)"mpeg2Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mpeg2Settings.adaptiveQuantizationAsString(), ADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.codecLevelAsString(), CODECLEVEL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.codecProfileAsString(), CODECPROFILE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.framerateControlAsString(), FRAMERATECONTROL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.framerateConversionAlgorithmAsString(), FRAMERATECONVERSIONALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.framerateDenominator(), FRAMERATEDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.framerateNumerator(), FRAMERATENUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.gopClosedCadence(), GOPCLOSEDCADENCE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.gopSize(), GOPSIZE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.gopSizeUnitsAsString(), GOPSIZEUNITS_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.hrdBufferInitialFillPercentage(), HRDBUFFERINITIALFILLPERCENTAGE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.hrdBufferSize(), HRDBUFFERSIZE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.interlaceModeAsString(), INTERLACEMODE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.intraDcPrecisionAsString(), INTRADCPRECISION_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.maxBitrate(), MAXBITRATE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.minIInterval(), MINIINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.numberBFramesBetweenReferenceFrames(), NUMBERBFRAMESBETWEENREFERENCEFRAMES_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.parControlAsString(), PARCONTROL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.parDenominator(), PARDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.parNumerator(), PARNUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.qualityTuningLevelAsString(), QUALITYTUNINGLEVEL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.rateControlModeAsString(), RATECONTROLMODE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.sceneChangeDetectAsString(), SCENECHANGEDETECT_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.slowPalAsString(), SLOWPAL_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.softness(), SOFTNESS_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.spatialAdaptiveQuantizationAsString(), SPATIALADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.syntaxAsString(), SYNTAX_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.telecineAsString(), TELECINE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.temporalAdaptiveQuantizationAsString(), TEMPORALADAPTIVEQUANTIZATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

