/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.HlsSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsSettingsMarshaller {
    private static final MarshallingInfo<String> AUDIOGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioGroupId").isBinary(false).build();
    private static final MarshallingInfo<String> AUDIORENDITIONSETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioRenditionSets").isBinary(false).build();
    private static final MarshallingInfo<String> AUDIOTRACKTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioTrackType").isBinary(false).build();
    private static final MarshallingInfo<String> IFRAMEONLYMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iFrameOnlyManifest").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTMODIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentModifier").isBinary(false).build();
    private static final HlsSettingsMarshaller INSTANCE = new HlsSettingsMarshaller();

    private HlsSettingsMarshaller() {
    }

    public static HlsSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsSettings hlsSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsSettings, (String)"hlsSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hlsSettings.audioGroupId(), AUDIOGROUPID_BINDING);
            protocolMarshaller.marshall((Object)hlsSettings.audioRenditionSets(), AUDIORENDITIONSETS_BINDING);
            protocolMarshaller.marshall((Object)hlsSettings.audioTrackTypeAsString(), AUDIOTRACKTYPE_BINDING);
            protocolMarshaller.marshall((Object)hlsSettings.iFrameOnlyManifestAsString(), IFRAMEONLYMANIFEST_BINDING);
            protocolMarshaller.marshall((Object)hlsSettings.segmentModifier(), SEGMENTMODIFIER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

