/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageMapping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsCaptionLanguageMappingMarshaller {
    private static final MarshallingInfo<Integer> CAPTIONCHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionChannel").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCode").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageDescription").isBinary(false).build();
    private static final HlsCaptionLanguageMappingMarshaller INSTANCE = new HlsCaptionLanguageMappingMarshaller();

    private HlsCaptionLanguageMappingMarshaller() {
    }

    public static HlsCaptionLanguageMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsCaptionLanguageMapping hlsCaptionLanguageMapping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsCaptionLanguageMapping, (String)"hlsCaptionLanguageMapping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hlsCaptionLanguageMapping.captionChannel(), CAPTIONCHANNEL_BINDING);
            protocolMarshaller.marshall((Object)hlsCaptionLanguageMapping.languageCodeAsString(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)hlsCaptionLanguageMapping.languageDescription(), LANGUAGEDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

