/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.F4vSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class F4vSettingsMarshaller {
    private static final MarshallingInfo<String> MOOVPLACEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("moovPlacement").isBinary(false).build();
    private static final F4vSettingsMarshaller INSTANCE = new F4vSettingsMarshaller();

    private F4vSettingsMarshaller() {
    }

    public static F4vSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(F4vSettings f4vSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)f4vSettings, (String)"f4vSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)f4vSettings.moovPlacementAsString(), MOOVPLACEMENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

