/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDescriptionPreset;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CaptionDescriptionPresetMarshaller {
    private static final MarshallingInfo<StructuredPojo> DESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationSettings").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCode").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageDescription").isBinary(false).build();
    private static final CaptionDescriptionPresetMarshaller INSTANCE = new CaptionDescriptionPresetMarshaller();

    private CaptionDescriptionPresetMarshaller() {
    }

    public static CaptionDescriptionPresetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CaptionDescriptionPreset captionDescriptionPreset, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)captionDescriptionPreset, (String)"captionDescriptionPreset");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)captionDescriptionPreset.destinationSettings(), DESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDescriptionPreset.languageCodeAsString(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)captionDescriptionPreset.languageDescription(), LANGUAGEDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

