/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.ListOf__integerCopier;
import software.amazon.awssdk.services.mediaconvert.transform.OutputChannelMappingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputChannelMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputChannelMapping> {
    private final List<Integer> inputChannels;

    private OutputChannelMapping(BuilderImpl builder) {
        this.inputChannels = builder.inputChannels;
    }

    public List<Integer> inputChannels() {
        return this.inputChannels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputChannels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputChannelMapping)) {
            return false;
        }
        OutputChannelMapping other = (OutputChannelMapping)obj;
        return Objects.equals(this.inputChannels(), other.inputChannels());
    }

    public String toString() {
        return ToString.builder((String)"OutputChannelMapping").add("InputChannels", this.inputChannels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputChannels": {
                return Optional.ofNullable(clazz.cast(this.inputChannels()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputChannelMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> inputChannels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputChannelMapping model) {
            this.inputChannels(model.inputChannels);
        }

        public final Collection<Integer> getInputChannels() {
            return this.inputChannels;
        }

        @Override
        public final Builder inputChannels(Collection<Integer> inputChannels) {
            this.inputChannels = ListOf__integerCopier.copy(inputChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannels(Integer ... inputChannels) {
            this.inputChannels(Arrays.asList(inputChannels));
            return this;
        }

        public final void setInputChannels(Collection<Integer> inputChannels) {
            this.inputChannels = ListOf__integerCopier.copy(inputChannels);
        }

        public OutputChannelMapping build() {
            return new OutputChannelMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputChannelMapping> {
        public Builder inputChannels(Collection<Integer> var1);

        public Builder inputChannels(Integer ... var1);
    }
}

