/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.ListOf__integerCopier;
import software.amazon.awssdk.services.mediaconvert.model.M3u8PcrControl;
import software.amazon.awssdk.services.mediaconvert.model.M3u8Scte35Source;
import software.amazon.awssdk.services.mediaconvert.model.TimedMetadata;
import software.amazon.awssdk.services.mediaconvert.transform.M3u8SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class M3u8Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, M3u8Settings> {
    private final Integer audioFramesPerPes;
    private final List<Integer> audioPids;
    private final Integer patInterval;
    private final String pcrControl;
    private final Integer pcrPid;
    private final Integer pmtInterval;
    private final Integer pmtPid;
    private final Integer privateMetadataPid;
    private final Integer programNumber;
    private final Integer scte35Pid;
    private final String scte35Source;
    private final String timedMetadata;
    private final Integer timedMetadataPid;
    private final Integer transportStreamId;
    private final Integer videoPid;

    private M3u8Settings(BuilderImpl builder) {
        this.audioFramesPerPes = builder.audioFramesPerPes;
        this.audioPids = builder.audioPids;
        this.patInterval = builder.patInterval;
        this.pcrControl = builder.pcrControl;
        this.pcrPid = builder.pcrPid;
        this.pmtInterval = builder.pmtInterval;
        this.pmtPid = builder.pmtPid;
        this.privateMetadataPid = builder.privateMetadataPid;
        this.programNumber = builder.programNumber;
        this.scte35Pid = builder.scte35Pid;
        this.scte35Source = builder.scte35Source;
        this.timedMetadata = builder.timedMetadata;
        this.timedMetadataPid = builder.timedMetadataPid;
        this.transportStreamId = builder.transportStreamId;
        this.videoPid = builder.videoPid;
    }

    public Integer audioFramesPerPes() {
        return this.audioFramesPerPes;
    }

    public List<Integer> audioPids() {
        return this.audioPids;
    }

    public Integer patInterval() {
        return this.patInterval;
    }

    public M3u8PcrControl pcrControl() {
        return M3u8PcrControl.fromValue(this.pcrControl);
    }

    public String pcrControlAsString() {
        return this.pcrControl;
    }

    public Integer pcrPid() {
        return this.pcrPid;
    }

    public Integer pmtInterval() {
        return this.pmtInterval;
    }

    public Integer pmtPid() {
        return this.pmtPid;
    }

    public Integer privateMetadataPid() {
        return this.privateMetadataPid;
    }

    public Integer programNumber() {
        return this.programNumber;
    }

    public Integer scte35Pid() {
        return this.scte35Pid;
    }

    public M3u8Scte35Source scte35Source() {
        return M3u8Scte35Source.fromValue(this.scte35Source);
    }

    public String scte35SourceAsString() {
        return this.scte35Source;
    }

    public TimedMetadata timedMetadata() {
        return TimedMetadata.fromValue(this.timedMetadata);
    }

    public String timedMetadataAsString() {
        return this.timedMetadata;
    }

    public Integer timedMetadataPid() {
        return this.timedMetadataPid;
    }

    public Integer transportStreamId() {
        return this.transportStreamId;
    }

    public Integer videoPid() {
        return this.videoPid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioFramesPerPes());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioPids());
        hashCode = 31 * hashCode + Objects.hashCode(this.patInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35SourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoPid());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M3u8Settings)) {
            return false;
        }
        M3u8Settings other = (M3u8Settings)obj;
        return Objects.equals(this.audioFramesPerPes(), other.audioFramesPerPes()) && Objects.equals(this.audioPids(), other.audioPids()) && Objects.equals(this.patInterval(), other.patInterval()) && Objects.equals(this.pcrControlAsString(), other.pcrControlAsString()) && Objects.equals(this.pcrPid(), other.pcrPid()) && Objects.equals(this.pmtInterval(), other.pmtInterval()) && Objects.equals(this.pmtPid(), other.pmtPid()) && Objects.equals(this.privateMetadataPid(), other.privateMetadataPid()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.scte35Pid(), other.scte35Pid()) && Objects.equals(this.scte35SourceAsString(), other.scte35SourceAsString()) && Objects.equals(this.timedMetadataAsString(), other.timedMetadataAsString()) && Objects.equals(this.timedMetadataPid(), other.timedMetadataPid()) && Objects.equals(this.transportStreamId(), other.transportStreamId()) && Objects.equals(this.videoPid(), other.videoPid());
    }

    public String toString() {
        return ToString.builder((String)"M3u8Settings").add("AudioFramesPerPes", (Object)this.audioFramesPerPes()).add("AudioPids", this.audioPids()).add("PatInterval", (Object)this.patInterval()).add("PcrControl", (Object)this.pcrControlAsString()).add("PcrPid", (Object)this.pcrPid()).add("PmtInterval", (Object)this.pmtInterval()).add("PmtPid", (Object)this.pmtPid()).add("PrivateMetadataPid", (Object)this.privateMetadataPid()).add("ProgramNumber", (Object)this.programNumber()).add("Scte35Pid", (Object)this.scte35Pid()).add("Scte35Source", (Object)this.scte35SourceAsString()).add("TimedMetadata", (Object)this.timedMetadataAsString()).add("TimedMetadataPid", (Object)this.timedMetadataPid()).add("TransportStreamId", (Object)this.transportStreamId()).add("VideoPid", (Object)this.videoPid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioFramesPerPes": {
                return Optional.ofNullable(clazz.cast(this.audioFramesPerPes()));
            }
            case "AudioPids": {
                return Optional.ofNullable(clazz.cast(this.audioPids()));
            }
            case "PatInterval": {
                return Optional.ofNullable(clazz.cast(this.patInterval()));
            }
            case "PcrControl": {
                return Optional.ofNullable(clazz.cast(this.pcrControlAsString()));
            }
            case "PcrPid": {
                return Optional.ofNullable(clazz.cast(this.pcrPid()));
            }
            case "PmtInterval": {
                return Optional.ofNullable(clazz.cast(this.pmtInterval()));
            }
            case "PmtPid": {
                return Optional.ofNullable(clazz.cast(this.pmtPid()));
            }
            case "PrivateMetadataPid": {
                return Optional.ofNullable(clazz.cast(this.privateMetadataPid()));
            }
            case "ProgramNumber": {
                return Optional.ofNullable(clazz.cast(this.programNumber()));
            }
            case "Scte35Pid": {
                return Optional.ofNullable(clazz.cast(this.scte35Pid()));
            }
            case "Scte35Source": {
                return Optional.ofNullable(clazz.cast(this.scte35SourceAsString()));
            }
            case "TimedMetadata": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataAsString()));
            }
            case "TimedMetadataPid": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataPid()));
            }
            case "TransportStreamId": {
                return Optional.ofNullable(clazz.cast(this.transportStreamId()));
            }
            case "VideoPid": {
                return Optional.ofNullable(clazz.cast(this.videoPid()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        M3u8SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer audioFramesPerPes;
        private List<Integer> audioPids = DefaultSdkAutoConstructList.getInstance();
        private Integer patInterval;
        private String pcrControl;
        private Integer pcrPid;
        private Integer pmtInterval;
        private Integer pmtPid;
        private Integer privateMetadataPid;
        private Integer programNumber;
        private Integer scte35Pid;
        private String scte35Source;
        private String timedMetadata;
        private Integer timedMetadataPid;
        private Integer transportStreamId;
        private Integer videoPid;

        private BuilderImpl() {
        }

        private BuilderImpl(M3u8Settings model) {
            this.audioFramesPerPes(model.audioFramesPerPes);
            this.audioPids(model.audioPids);
            this.patInterval(model.patInterval);
            this.pcrControl(model.pcrControl);
            this.pcrPid(model.pcrPid);
            this.pmtInterval(model.pmtInterval);
            this.pmtPid(model.pmtPid);
            this.privateMetadataPid(model.privateMetadataPid);
            this.programNumber(model.programNumber);
            this.scte35Pid(model.scte35Pid);
            this.scte35Source(model.scte35Source);
            this.timedMetadata(model.timedMetadata);
            this.timedMetadataPid(model.timedMetadataPid);
            this.transportStreamId(model.transportStreamId);
            this.videoPid(model.videoPid);
        }

        public final Integer getAudioFramesPerPes() {
            return this.audioFramesPerPes;
        }

        @Override
        public final Builder audioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
            return this;
        }

        public final void setAudioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
        }

        public final Collection<Integer> getAudioPids() {
            return this.audioPids;
        }

        @Override
        public final Builder audioPids(Collection<Integer> audioPids) {
            this.audioPids = ListOf__integerCopier.copy(audioPids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioPids(Integer ... audioPids) {
            this.audioPids(Arrays.asList(audioPids));
            return this;
        }

        public final void setAudioPids(Collection<Integer> audioPids) {
            this.audioPids = ListOf__integerCopier.copy(audioPids);
        }

        public final Integer getPatInterval() {
            return this.patInterval;
        }

        @Override
        public final Builder patInterval(Integer patInterval) {
            this.patInterval = patInterval;
            return this;
        }

        public final void setPatInterval(Integer patInterval) {
            this.patInterval = patInterval;
        }

        public final String getPcrControl() {
            return this.pcrControl;
        }

        @Override
        public final Builder pcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
            return this;
        }

        @Override
        public final Builder pcrControl(M3u8PcrControl pcrControl) {
            this.pcrControl(pcrControl.toString());
            return this;
        }

        public final void setPcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
        }

        public final Integer getPcrPid() {
            return this.pcrPid;
        }

        @Override
        public final Builder pcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final void setPcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
        }

        public final Integer getPmtInterval() {
            return this.pmtInterval;
        }

        @Override
        public final Builder pmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
            return this;
        }

        public final void setPmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
        }

        public final Integer getPmtPid() {
            return this.pmtPid;
        }

        @Override
        public final Builder pmtPid(Integer pmtPid) {
            this.pmtPid = pmtPid;
            return this;
        }

        public final void setPmtPid(Integer pmtPid) {
            this.pmtPid = pmtPid;
        }

        public final Integer getPrivateMetadataPid() {
            return this.privateMetadataPid;
        }

        @Override
        public final Builder privateMetadataPid(Integer privateMetadataPid) {
            this.privateMetadataPid = privateMetadataPid;
            return this;
        }

        public final void setPrivateMetadataPid(Integer privateMetadataPid) {
            this.privateMetadataPid = privateMetadataPid;
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        public final Integer getScte35Pid() {
            return this.scte35Pid;
        }

        @Override
        public final Builder scte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final void setScte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        public final String getScte35Source() {
            return this.scte35Source;
        }

        @Override
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        public final Builder scte35Source(M3u8Scte35Source scte35Source) {
            this.scte35Source(scte35Source.toString());
            return this;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        public final String getTimedMetadata() {
            return this.timedMetadata;
        }

        @Override
        public final Builder timedMetadata(String timedMetadata) {
            this.timedMetadata = timedMetadata;
            return this;
        }

        @Override
        public final Builder timedMetadata(TimedMetadata timedMetadata) {
            this.timedMetadata(timedMetadata.toString());
            return this;
        }

        public final void setTimedMetadata(String timedMetadata) {
            this.timedMetadata = timedMetadata;
        }

        public final Integer getTimedMetadataPid() {
            return this.timedMetadataPid;
        }

        @Override
        public final Builder timedMetadataPid(Integer timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
            return this;
        }

        public final void setTimedMetadataPid(Integer timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
        }

        public final Integer getTransportStreamId() {
            return this.transportStreamId;
        }

        @Override
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        public final Integer getVideoPid() {
            return this.videoPid;
        }

        @Override
        public final Builder videoPid(Integer videoPid) {
            this.videoPid = videoPid;
            return this;
        }

        public final void setVideoPid(Integer videoPid) {
            this.videoPid = videoPid;
        }

        public M3u8Settings build() {
            return new M3u8Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, M3u8Settings> {
        public Builder audioFramesPerPes(Integer var1);

        public Builder audioPids(Collection<Integer> var1);

        public Builder audioPids(Integer ... var1);

        public Builder patInterval(Integer var1);

        public Builder pcrControl(String var1);

        public Builder pcrControl(M3u8PcrControl var1);

        public Builder pcrPid(Integer var1);

        public Builder pmtInterval(Integer var1);

        public Builder pmtPid(Integer var1);

        public Builder privateMetadataPid(Integer var1);

        public Builder programNumber(Integer var1);

        public Builder scte35Pid(Integer var1);

        public Builder scte35Source(String var1);

        public Builder scte35Source(M3u8Scte35Source var1);

        public Builder timedMetadata(String var1);

        public Builder timedMetadata(TimedMetadata var1);

        public Builder timedMetadataPid(Integer var1);

        public Builder transportStreamId(Integer var1);

        public Builder videoPid(Integer var1);
    }
}

