/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.ListOfQueueCopier;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertResponse;
import software.amazon.awssdk.services.mediaconvert.model.Queue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueuesResponse
extends MediaConvertResponse
implements ToCopyableBuilder<Builder, ListQueuesResponse> {
    private final String nextToken;
    private final List<Queue> queues;

    private ListQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.queues = builder.queues;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<Queue> queues() {
        return this.queues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.queues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.queues(), other.queues());
    }

    public String toString() {
        return ToString.builder((String)"ListQueuesResponse").add("NextToken", (Object)this.nextToken()).add("Queues", this.queues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaConvertResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Queue> queues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.queues(model.queues);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<Queue.Builder> getQueues() {
            return this.queues != null ? (Collection)this.queues.stream().map(Queue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queues(Collection<Queue> queues) {
            this.queues = ListOfQueueCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Queue ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Consumer<Queue.Builder> ... queues) {
            this.queues(Stream.of(queues).map(c -> (Queue)((Queue.Builder)Queue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueues(Collection<Queue.BuilderImpl> queues) {
            this.queues = ListOfQueueCopier.copyFromBuilder(queues);
        }

        @Override
        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }
    }

    public static interface Builder
    extends MediaConvertResponse.Builder,
    CopyableBuilder<Builder, ListQueuesResponse> {
        public Builder nextToken(String var1);

        public Builder queues(Collection<Queue> var1);

        public Builder queues(Queue ... var1);

        public Builder queues(Consumer<Queue.Builder> ... var1);
    }
}

