/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconvert.model.JobSettings;
import software.amazon.awssdk.services.mediaconvert.model.JobStatus;
import software.amazon.awssdk.services.mediaconvert.model.ListOfOutputGroupDetailCopier;
import software.amazon.awssdk.services.mediaconvert.model.MapOf__stringCopier;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroupDetail;
import software.amazon.awssdk.services.mediaconvert.model.Timing;
import software.amazon.awssdk.services.mediaconvert.transform.JobMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Job
implements StructuredPojo,
ToCopyableBuilder<Builder, Job> {
    private final String arn;
    private final Instant createdAt;
    private final Integer errorCode;
    private final String errorMessage;
    private final String id;
    private final String jobTemplate;
    private final List<OutputGroupDetail> outputGroupDetails;
    private final String queue;
    private final String role;
    private final JobSettings settings;
    private final String status;
    private final Timing timing;
    private final Map<String, String> userMetadata;

    private Job(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.id = builder.id;
        this.jobTemplate = builder.jobTemplate;
        this.outputGroupDetails = builder.outputGroupDetails;
        this.queue = builder.queue;
        this.role = builder.role;
        this.settings = builder.settings;
        this.status = builder.status;
        this.timing = builder.timing;
        this.userMetadata = builder.userMetadata;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Integer errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String id() {
        return this.id;
    }

    public String jobTemplate() {
        return this.jobTemplate;
    }

    public List<OutputGroupDetail> outputGroupDetails() {
        return this.outputGroupDetails;
    }

    public String queue() {
        return this.queue;
    }

    public String role() {
        return this.role;
    }

    public JobSettings settings() {
        return this.settings;
    }

    public JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Timing timing() {
        return this.timing;
    }

    public Map<String, String> userMetadata() {
        return this.userMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputGroupDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timing());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.jobTemplate(), other.jobTemplate()) && Objects.equals(this.outputGroupDetails(), other.outputGroupDetails()) && Objects.equals(this.queue(), other.queue()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.timing(), other.timing()) && Objects.equals(this.userMetadata(), other.userMetadata());
    }

    public String toString() {
        return ToString.builder((String)"Job").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("ErrorCode", (Object)this.errorCode()).add("ErrorMessage", (Object)this.errorMessage()).add("Id", (Object)this.id()).add("JobTemplate", (Object)this.jobTemplate()).add("OutputGroupDetails", this.outputGroupDetails()).add("Queue", (Object)this.queue()).add("Role", (Object)this.role()).add("Settings", (Object)this.settings()).add("Status", (Object)this.statusAsString()).add("Timing", (Object)this.timing()).add("UserMetadata", this.userMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "JobTemplate": {
                return Optional.ofNullable(clazz.cast(this.jobTemplate()));
            }
            case "OutputGroupDetails": {
                return Optional.ofNullable(clazz.cast(this.outputGroupDetails()));
            }
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Timing": {
                return Optional.ofNullable(clazz.cast(this.timing()));
            }
            case "UserMetadata": {
                return Optional.ofNullable(clazz.cast(this.userMetadata()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private Integer errorCode;
        private String errorMessage;
        private String id;
        private String jobTemplate;
        private List<OutputGroupDetail> outputGroupDetails = DefaultSdkAutoConstructList.getInstance();
        private String queue;
        private String role;
        private JobSettings settings;
        private String status;
        private Timing timing;
        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
            this.id(model.id);
            this.jobTemplate(model.jobTemplate);
            this.outputGroupDetails(model.outputGroupDetails);
            this.queue(model.queue);
            this.role(model.role);
            this.settings(model.settings);
            this.status(model.status);
            this.timing(model.timing);
            this.userMetadata(model.userMetadata);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Integer getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getJobTemplate() {
            return this.jobTemplate;
        }

        @Override
        public final Builder jobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
            return this;
        }

        public final void setJobTemplate(String jobTemplate) {
            this.jobTemplate = jobTemplate;
        }

        public final Collection<OutputGroupDetail.Builder> getOutputGroupDetails() {
            return this.outputGroupDetails != null ? (Collection)this.outputGroupDetails.stream().map(OutputGroupDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputGroupDetails(Collection<OutputGroupDetail> outputGroupDetails) {
            this.outputGroupDetails = ListOfOutputGroupDetailCopier.copy(outputGroupDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroupDetails(OutputGroupDetail ... outputGroupDetails) {
            this.outputGroupDetails(Arrays.asList(outputGroupDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroupDetails(Consumer<OutputGroupDetail.Builder> ... outputGroupDetails) {
            this.outputGroupDetails(Stream.of(outputGroupDetails).map(c -> (OutputGroupDetail)((OutputGroupDetail.Builder)OutputGroupDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputGroupDetails(Collection<OutputGroupDetail.BuilderImpl> outputGroupDetails) {
            this.outputGroupDetails = ListOfOutputGroupDetailCopier.copyFromBuilder(outputGroupDetails);
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final JobSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(JobSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(JobSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Timing.Builder getTiming() {
            return this.timing != null ? this.timing.toBuilder() : null;
        }

        @Override
        public final Builder timing(Timing timing) {
            this.timing = timing;
            return this;
        }

        public final void setTiming(Timing.BuilderImpl timing) {
            this.timing = timing != null ? timing.build() : null;
        }

        public final Map<String, String> getUserMetadata() {
            return this.userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = MapOf__stringCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = MapOf__stringCopier.copy(userMetadata);
        }

        public Job build() {
            return new Job(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Job> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder errorCode(Integer var1);

        public Builder errorMessage(String var1);

        public Builder id(String var1);

        public Builder jobTemplate(String var1);

        public Builder outputGroupDetails(Collection<OutputGroupDetail> var1);

        public Builder outputGroupDetails(OutputGroupDetail ... var1);

        public Builder outputGroupDetails(Consumer<OutputGroupDetail.Builder> ... var1);

        public Builder queue(String var1);

        public Builder role(String var1);

        public Builder settings(JobSettings var1);

        default public Builder settings(Consumer<JobSettings.Builder> settings) {
            return this.settings((JobSettings)((JobSettings.Builder)JobSettings.builder().applyMutation(settings)).build());
        }

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder timing(Timing var1);

        default public Builder timing(Consumer<Timing.Builder> timing) {
            return this.timing((Timing)((Timing.Builder)Timing.builder().applyMutation(timing)).build());
        }

        public Builder userMetadata(Map<String, String> var1);
    }
}

