/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.services.mediaconvert.transform.HlsCaptionLanguageMappingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsCaptionLanguageMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsCaptionLanguageMapping> {
    private final Integer captionChannel;
    private final String languageCode;
    private final String languageDescription;

    private HlsCaptionLanguageMapping(BuilderImpl builder) {
        this.captionChannel = builder.captionChannel;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
    }

    public Integer captionChannel() {
        return this.captionChannel;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public String languageDescription() {
        return this.languageDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.captionChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsCaptionLanguageMapping)) {
            return false;
        }
        HlsCaptionLanguageMapping other = (HlsCaptionLanguageMapping)obj;
        return Objects.equals(this.captionChannel(), other.captionChannel()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.languageDescription(), other.languageDescription());
    }

    public String toString() {
        return ToString.builder((String)"HlsCaptionLanguageMapping").add("CaptionChannel", (Object)this.captionChannel()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LanguageDescription", (Object)this.languageDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CaptionChannel": {
                return Optional.ofNullable(clazz.cast(this.captionChannel()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LanguageDescription": {
                return Optional.ofNullable(clazz.cast(this.languageDescription()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsCaptionLanguageMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer captionChannel;
        private String languageCode;
        private String languageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsCaptionLanguageMapping model) {
            this.captionChannel(model.captionChannel);
            this.languageCode(model.languageCode);
            this.languageDescription(model.languageDescription);
        }

        public final Integer getCaptionChannel() {
            return this.captionChannel;
        }

        @Override
        public final Builder captionChannel(Integer captionChannel) {
            this.captionChannel = captionChannel;
            return this;
        }

        public final void setCaptionChannel(Integer captionChannel) {
            this.captionChannel = captionChannel;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageDescription() {
            return this.languageDescription;
        }

        @Override
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        public HlsCaptionLanguageMapping build() {
            return new HlsCaptionLanguageMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsCaptionLanguageMapping> {
        public Builder captionChannel(Integer var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder languageDescription(String var1);
    }
}

