/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.H265AdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H265AlternateTransferFunctionSei;
import software.amazon.awssdk.services.mediaconvert.model.H265CodecLevel;
import software.amazon.awssdk.services.mediaconvert.model.H265CodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.H265FlickerAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H265FramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.H265FramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.H265GopBReference;
import software.amazon.awssdk.services.mediaconvert.model.H265GopSizeUnits;
import software.amazon.awssdk.services.mediaconvert.model.H265InterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.H265ParControl;
import software.amazon.awssdk.services.mediaconvert.model.H265QualityTuningLevel;
import software.amazon.awssdk.services.mediaconvert.model.H265RateControlMode;
import software.amazon.awssdk.services.mediaconvert.model.H265SampleAdaptiveOffsetFilterMode;
import software.amazon.awssdk.services.mediaconvert.model.H265SceneChangeDetect;
import software.amazon.awssdk.services.mediaconvert.model.H265SlowPal;
import software.amazon.awssdk.services.mediaconvert.model.H265SpatialAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H265Telecine;
import software.amazon.awssdk.services.mediaconvert.model.H265TemporalAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H265TemporalIds;
import software.amazon.awssdk.services.mediaconvert.model.H265Tiles;
import software.amazon.awssdk.services.mediaconvert.model.H265UnregisteredSeiTimecode;
import software.amazon.awssdk.services.mediaconvert.transform.H265SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H265Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, H265Settings> {
    private final String adaptiveQuantization;
    private final String alternateTransferFunctionSei;
    private final Integer bitrate;
    private final String codecLevel;
    private final String codecProfile;
    private final String flickerAdaptiveQuantization;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String gopBReference;
    private final Integer gopClosedCadence;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final Integer hrdBufferInitialFillPercentage;
    private final Integer hrdBufferSize;
    private final String interlaceMode;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer numberBFramesBetweenReferenceFrames;
    private final Integer numberReferenceFrames;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String qualityTuningLevel;
    private final String rateControlMode;
    private final String sampleAdaptiveOffsetFilterMode;
    private final String sceneChangeDetect;
    private final Integer slices;
    private final String slowPal;
    private final String spatialAdaptiveQuantization;
    private final String telecine;
    private final String temporalAdaptiveQuantization;
    private final String temporalIds;
    private final String tiles;
    private final String unregisteredSeiTimecode;

    private H265Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.alternateTransferFunctionSei = builder.alternateTransferFunctionSei;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.numberReferenceFrames = builder.numberReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.rateControlMode = builder.rateControlMode;
        this.sampleAdaptiveOffsetFilterMode = builder.sampleAdaptiveOffsetFilterMode;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.slowPal = builder.slowPal;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
        this.temporalIds = builder.temporalIds;
        this.tiles = builder.tiles;
        this.unregisteredSeiTimecode = builder.unregisteredSeiTimecode;
    }

    public H265AdaptiveQuantization adaptiveQuantization() {
        return H265AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public H265AlternateTransferFunctionSei alternateTransferFunctionSei() {
        return H265AlternateTransferFunctionSei.fromValue(this.alternateTransferFunctionSei);
    }

    public String alternateTransferFunctionSeiAsString() {
        return this.alternateTransferFunctionSei;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public H265CodecLevel codecLevel() {
        return H265CodecLevel.fromValue(this.codecLevel);
    }

    public String codecLevelAsString() {
        return this.codecLevel;
    }

    public H265CodecProfile codecProfile() {
        return H265CodecProfile.fromValue(this.codecProfile);
    }

    public String codecProfileAsString() {
        return this.codecProfile;
    }

    public H265FlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return H265FlickerAdaptiveQuantization.fromValue(this.flickerAdaptiveQuantization);
    }

    public String flickerAdaptiveQuantizationAsString() {
        return this.flickerAdaptiveQuantization;
    }

    public H265FramerateControl framerateControl() {
        return H265FramerateControl.fromValue(this.framerateControl);
    }

    public String framerateControlAsString() {
        return this.framerateControl;
    }

    public H265FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return H265FramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public H265GopBReference gopBReference() {
        return H265GopBReference.fromValue(this.gopBReference);
    }

    public String gopBReferenceAsString() {
        return this.gopBReference;
    }

    public Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public Double gopSize() {
        return this.gopSize;
    }

    public H265GopSizeUnits gopSizeUnits() {
        return H265GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public Integer hrdBufferInitialFillPercentage() {
        return this.hrdBufferInitialFillPercentage;
    }

    public Integer hrdBufferSize() {
        return this.hrdBufferSize;
    }

    public H265InterlaceMode interlaceMode() {
        return H265InterlaceMode.fromValue(this.interlaceMode);
    }

    public String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Integer minIInterval() {
        return this.minIInterval;
    }

    public Integer numberBFramesBetweenReferenceFrames() {
        return this.numberBFramesBetweenReferenceFrames;
    }

    public Integer numberReferenceFrames() {
        return this.numberReferenceFrames;
    }

    public H265ParControl parControl() {
        return H265ParControl.fromValue(this.parControl);
    }

    public String parControlAsString() {
        return this.parControl;
    }

    public Integer parDenominator() {
        return this.parDenominator;
    }

    public Integer parNumerator() {
        return this.parNumerator;
    }

    public H265QualityTuningLevel qualityTuningLevel() {
        return H265QualityTuningLevel.fromValue(this.qualityTuningLevel);
    }

    public String qualityTuningLevelAsString() {
        return this.qualityTuningLevel;
    }

    public H265RateControlMode rateControlMode() {
        return H265RateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public H265SampleAdaptiveOffsetFilterMode sampleAdaptiveOffsetFilterMode() {
        return H265SampleAdaptiveOffsetFilterMode.fromValue(this.sampleAdaptiveOffsetFilterMode);
    }

    public String sampleAdaptiveOffsetFilterModeAsString() {
        return this.sampleAdaptiveOffsetFilterMode;
    }

    public H265SceneChangeDetect sceneChangeDetect() {
        return H265SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public String sceneChangeDetectAsString() {
        return this.sceneChangeDetect;
    }

    public Integer slices() {
        return this.slices;
    }

    public H265SlowPal slowPal() {
        return H265SlowPal.fromValue(this.slowPal);
    }

    public String slowPalAsString() {
        return this.slowPal;
    }

    public H265SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return H265SpatialAdaptiveQuantization.fromValue(this.spatialAdaptiveQuantization);
    }

    public String spatialAdaptiveQuantizationAsString() {
        return this.spatialAdaptiveQuantization;
    }

    public H265Telecine telecine() {
        return H265Telecine.fromValue(this.telecine);
    }

    public String telecineAsString() {
        return this.telecine;
    }

    public H265TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return H265TemporalAdaptiveQuantization.fromValue(this.temporalAdaptiveQuantization);
    }

    public String temporalAdaptiveQuantizationAsString() {
        return this.temporalAdaptiveQuantization;
    }

    public H265TemporalIds temporalIds() {
        return H265TemporalIds.fromValue(this.temporalIds);
    }

    public String temporalIdsAsString() {
        return this.temporalIds;
    }

    public H265Tiles tiles() {
        return H265Tiles.fromValue(this.tiles);
    }

    public String tilesAsString() {
        return this.tiles;
    }

    public H265UnregisteredSeiTimecode unregisteredSeiTimecode() {
        return H265UnregisteredSeiTimecode.fromValue(this.unregisteredSeiTimecode);
    }

    public String unregisteredSeiTimecodeAsString() {
        return this.unregisteredSeiTimecode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateTransferFunctionSeiAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flickerAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleAdaptiveOffsetFilterModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slices());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalIdsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tilesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unregisteredSeiTimecodeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H265Settings)) {
            return false;
        }
        H265Settings other = (H265Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.alternateTransferFunctionSeiAsString(), other.alternateTransferFunctionSeiAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codecLevelAsString(), other.codecLevelAsString()) && Objects.equals(this.codecProfileAsString(), other.codecProfileAsString()) && Objects.equals(this.flickerAdaptiveQuantizationAsString(), other.flickerAdaptiveQuantizationAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopBReferenceAsString(), other.gopBReferenceAsString()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage()) && Objects.equals(this.hrdBufferSize(), other.hrdBufferSize()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames()) && Objects.equals(this.numberReferenceFrames(), other.numberReferenceFrames()) && Objects.equals(this.parControlAsString(), other.parControlAsString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.qualityTuningLevelAsString(), other.qualityTuningLevelAsString()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.sampleAdaptiveOffsetFilterModeAsString(), other.sampleAdaptiveOffsetFilterModeAsString()) && Objects.equals(this.sceneChangeDetectAsString(), other.sceneChangeDetectAsString()) && Objects.equals(this.slices(), other.slices()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString()) && Objects.equals(this.temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString()) && Objects.equals(this.temporalIdsAsString(), other.temporalIdsAsString()) && Objects.equals(this.tilesAsString(), other.tilesAsString()) && Objects.equals(this.unregisteredSeiTimecodeAsString(), other.unregisteredSeiTimecodeAsString());
    }

    public String toString() {
        return ToString.builder((String)"H265Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("AlternateTransferFunctionSei", (Object)this.alternateTransferFunctionSeiAsString()).add("Bitrate", (Object)this.bitrate()).add("CodecLevel", (Object)this.codecLevelAsString()).add("CodecProfile", (Object)this.codecProfileAsString()).add("FlickerAdaptiveQuantization", (Object)this.flickerAdaptiveQuantizationAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopBReference", (Object)this.gopBReferenceAsString()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("HrdBufferInitialFillPercentage", (Object)this.hrdBufferInitialFillPercentage()).add("HrdBufferSize", (Object)this.hrdBufferSize()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("NumberBFramesBetweenReferenceFrames", (Object)this.numberBFramesBetweenReferenceFrames()).add("NumberReferenceFrames", (Object)this.numberReferenceFrames()).add("ParControl", (Object)this.parControlAsString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("QualityTuningLevel", (Object)this.qualityTuningLevelAsString()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("SampleAdaptiveOffsetFilterMode", (Object)this.sampleAdaptiveOffsetFilterModeAsString()).add("SceneChangeDetect", (Object)this.sceneChangeDetectAsString()).add("Slices", (Object)this.slices()).add("SlowPal", (Object)this.slowPalAsString()).add("SpatialAdaptiveQuantization", (Object)this.spatialAdaptiveQuantizationAsString()).add("Telecine", (Object)this.telecineAsString()).add("TemporalAdaptiveQuantization", (Object)this.temporalAdaptiveQuantizationAsString()).add("TemporalIds", (Object)this.temporalIdsAsString()).add("Tiles", (Object)this.tilesAsString()).add("UnregisteredSeiTimecode", (Object)this.unregisteredSeiTimecodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "AlternateTransferFunctionSei": {
                return Optional.ofNullable(clazz.cast(this.alternateTransferFunctionSeiAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "CodecLevel": {
                return Optional.ofNullable(clazz.cast(this.codecLevelAsString()));
            }
            case "CodecProfile": {
                return Optional.ofNullable(clazz.cast(this.codecProfileAsString()));
            }
            case "FlickerAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.flickerAdaptiveQuantizationAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopBReference": {
                return Optional.ofNullable(clazz.cast(this.gopBReferenceAsString()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "HrdBufferInitialFillPercentage": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferInitialFillPercentage()));
            }
            case "HrdBufferSize": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferSize()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.ofNullable(clazz.cast(this.minIInterval()));
            }
            case "NumberBFramesBetweenReferenceFrames": {
                return Optional.ofNullable(clazz.cast(this.numberBFramesBetweenReferenceFrames()));
            }
            case "NumberReferenceFrames": {
                return Optional.ofNullable(clazz.cast(this.numberReferenceFrames()));
            }
            case "ParControl": {
                return Optional.ofNullable(clazz.cast(this.parControlAsString()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "QualityTuningLevel": {
                return Optional.ofNullable(clazz.cast(this.qualityTuningLevelAsString()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "SampleAdaptiveOffsetFilterMode": {
                return Optional.ofNullable(clazz.cast(this.sampleAdaptiveOffsetFilterModeAsString()));
            }
            case "SceneChangeDetect": {
                return Optional.ofNullable(clazz.cast(this.sceneChangeDetectAsString()));
            }
            case "Slices": {
                return Optional.ofNullable(clazz.cast(this.slices()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "SpatialAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.spatialAdaptiveQuantizationAsString()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
            case "TemporalAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.temporalAdaptiveQuantizationAsString()));
            }
            case "TemporalIds": {
                return Optional.ofNullable(clazz.cast(this.temporalIdsAsString()));
            }
            case "Tiles": {
                return Optional.ofNullable(clazz.cast(this.tilesAsString()));
            }
            case "UnregisteredSeiTimecode": {
                return Optional.ofNullable(clazz.cast(this.unregisteredSeiTimecodeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        H265SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private String alternateTransferFunctionSei;
        private Integer bitrate;
        private String codecLevel;
        private String codecProfile;
        private String flickerAdaptiveQuantization;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String gopBReference;
        private Integer gopClosedCadence;
        private Double gopSize;
        private String gopSizeUnits;
        private Integer hrdBufferInitialFillPercentage;
        private Integer hrdBufferSize;
        private String interlaceMode;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer numberBFramesBetweenReferenceFrames;
        private Integer numberReferenceFrames;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private String qualityTuningLevel;
        private String rateControlMode;
        private String sampleAdaptiveOffsetFilterMode;
        private String sceneChangeDetect;
        private Integer slices;
        private String slowPal;
        private String spatialAdaptiveQuantization;
        private String telecine;
        private String temporalAdaptiveQuantization;
        private String temporalIds;
        private String tiles;
        private String unregisteredSeiTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(H265Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.alternateTransferFunctionSei(model.alternateTransferFunctionSei);
            this.bitrate(model.bitrate);
            this.codecLevel(model.codecLevel);
            this.codecProfile(model.codecProfile);
            this.flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopBReference(model.gopBReference);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            this.hrdBufferSize(model.hrdBufferSize);
            this.interlaceMode(model.interlaceMode);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            this.numberReferenceFrames(model.numberReferenceFrames);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.qualityTuningLevel(model.qualityTuningLevel);
            this.rateControlMode(model.rateControlMode);
            this.sampleAdaptiveOffsetFilterMode(model.sampleAdaptiveOffsetFilterMode);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.slices(model.slices);
            this.slowPal(model.slowPal);
            this.spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            this.telecine(model.telecine);
            this.temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
            this.temporalIds(model.temporalIds);
            this.tiles(model.tiles);
            this.unregisteredSeiTimecode(model.unregisteredSeiTimecode);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H265AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final String getAlternateTransferFunctionSei() {
            return this.alternateTransferFunctionSei;
        }

        @Override
        public final Builder alternateTransferFunctionSei(String alternateTransferFunctionSei) {
            this.alternateTransferFunctionSei = alternateTransferFunctionSei;
            return this;
        }

        @Override
        public final Builder alternateTransferFunctionSei(H265AlternateTransferFunctionSei alternateTransferFunctionSei) {
            this.alternateTransferFunctionSei(alternateTransferFunctionSei.toString());
            return this;
        }

        public final void setAlternateTransferFunctionSei(String alternateTransferFunctionSei) {
            this.alternateTransferFunctionSei = alternateTransferFunctionSei;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecLevel() {
            return this.codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(H265CodecLevel codecLevel) {
            this.codecLevel(codecLevel.toString());
            return this;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        public final String getCodecProfile() {
            return this.codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(H265CodecProfile codecProfile) {
            this.codecProfile(codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getFlickerAdaptiveQuantization() {
            return this.flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(H265FlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization.toString());
            return this;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(H265FramerateControl framerateControl) {
            this.framerateControl(framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(H265FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getGopBReference() {
            return this.gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H265GopBReference gopBReference) {
            this.gopBReference(gopBReference.toString());
            return this;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H265GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits.toString());
            return this;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return this.hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        public final Integer getHrdBufferSize() {
            return this.hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(H265InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return this.numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final Integer getNumberReferenceFrames() {
            return this.numberReferenceFrames;
        }

        @Override
        public final Builder numberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
            return this;
        }

        public final void setNumberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
        }

        public final String getParControl() {
            return this.parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(H265ParControl parControl) {
            this.parControl(parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getQualityTuningLevel() {
            return this.qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(H265QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel.toString());
            return this;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H265RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getSampleAdaptiveOffsetFilterMode() {
            return this.sampleAdaptiveOffsetFilterMode;
        }

        @Override
        public final Builder sampleAdaptiveOffsetFilterMode(String sampleAdaptiveOffsetFilterMode) {
            this.sampleAdaptiveOffsetFilterMode = sampleAdaptiveOffsetFilterMode;
            return this;
        }

        @Override
        public final Builder sampleAdaptiveOffsetFilterMode(H265SampleAdaptiveOffsetFilterMode sampleAdaptiveOffsetFilterMode) {
            this.sampleAdaptiveOffsetFilterMode(sampleAdaptiveOffsetFilterMode.toString());
            return this;
        }

        public final void setSampleAdaptiveOffsetFilterMode(String sampleAdaptiveOffsetFilterMode) {
            this.sampleAdaptiveOffsetFilterMode = sampleAdaptiveOffsetFilterMode;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H265SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect.toString());
            return this;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        public final Integer getSlices() {
            return this.slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(H265SlowPal slowPal) {
            this.slowPal(slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final String getSpatialAdaptiveQuantization() {
            return this.spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(H265SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(H265Telecine telecine) {
            this.telecine(telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getTemporalAdaptiveQuantization() {
            return this.temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(H265TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization.toString());
            return this;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        public final String getTemporalIds() {
            return this.temporalIds;
        }

        @Override
        public final Builder temporalIds(String temporalIds) {
            this.temporalIds = temporalIds;
            return this;
        }

        @Override
        public final Builder temporalIds(H265TemporalIds temporalIds) {
            this.temporalIds(temporalIds.toString());
            return this;
        }

        public final void setTemporalIds(String temporalIds) {
            this.temporalIds = temporalIds;
        }

        public final String getTiles() {
            return this.tiles;
        }

        @Override
        public final Builder tiles(String tiles) {
            this.tiles = tiles;
            return this;
        }

        @Override
        public final Builder tiles(H265Tiles tiles) {
            this.tiles(tiles.toString());
            return this;
        }

        public final void setTiles(String tiles) {
            this.tiles = tiles;
        }

        public final String getUnregisteredSeiTimecode() {
            return this.unregisteredSeiTimecode;
        }

        @Override
        public final Builder unregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
            return this;
        }

        @Override
        public final Builder unregisteredSeiTimecode(H265UnregisteredSeiTimecode unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode(unregisteredSeiTimecode.toString());
            return this;
        }

        public final void setUnregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
        }

        public H265Settings build() {
            return new H265Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, H265Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(H265AdaptiveQuantization var1);

        public Builder alternateTransferFunctionSei(String var1);

        public Builder alternateTransferFunctionSei(H265AlternateTransferFunctionSei var1);

        public Builder bitrate(Integer var1);

        public Builder codecLevel(String var1);

        public Builder codecLevel(H265CodecLevel var1);

        public Builder codecProfile(String var1);

        public Builder codecProfile(H265CodecProfile var1);

        public Builder flickerAdaptiveQuantization(String var1);

        public Builder flickerAdaptiveQuantization(H265FlickerAdaptiveQuantization var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(H265FramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(H265FramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopBReference(String var1);

        public Builder gopBReference(H265GopBReference var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(H265GopSizeUnits var1);

        public Builder hrdBufferInitialFillPercentage(Integer var1);

        public Builder hrdBufferSize(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(H265InterlaceMode var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder numberBFramesBetweenReferenceFrames(Integer var1);

        public Builder numberReferenceFrames(Integer var1);

        public Builder parControl(String var1);

        public Builder parControl(H265ParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder qualityTuningLevel(String var1);

        public Builder qualityTuningLevel(H265QualityTuningLevel var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(H265RateControlMode var1);

        public Builder sampleAdaptiveOffsetFilterMode(String var1);

        public Builder sampleAdaptiveOffsetFilterMode(H265SampleAdaptiveOffsetFilterMode var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(H265SceneChangeDetect var1);

        public Builder slices(Integer var1);

        public Builder slowPal(String var1);

        public Builder slowPal(H265SlowPal var1);

        public Builder spatialAdaptiveQuantization(String var1);

        public Builder spatialAdaptiveQuantization(H265SpatialAdaptiveQuantization var1);

        public Builder telecine(String var1);

        public Builder telecine(H265Telecine var1);

        public Builder temporalAdaptiveQuantization(String var1);

        public Builder temporalAdaptiveQuantization(H265TemporalAdaptiveQuantization var1);

        public Builder temporalIds(String var1);

        public Builder temporalIds(H265TemporalIds var1);

        public Builder tiles(String var1);

        public Builder tiles(H265Tiles var1);

        public Builder unregisteredSeiTimecode(String var1);

        public Builder unregisteredSeiTimecode(H265UnregisteredSeiTimecode var1);
    }
}

