/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoHbbtvCompliance;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoSegmentControl;
import software.amazon.awssdk.services.mediaconvert.transform.DashIsoGroupSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashIsoGroupSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, DashIsoGroupSettings> {
    private final String baseUrl;
    private final String destination;
    private final DashIsoEncryptionSettings encryption;
    private final Integer fragmentLength;
    private final String hbbtvCompliance;
    private final Integer minBufferTime;
    private final String segmentControl;
    private final Integer segmentLength;

    private DashIsoGroupSettings(BuilderImpl builder) {
        this.baseUrl = builder.baseUrl;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.hbbtvCompliance = builder.hbbtvCompliance;
        this.minBufferTime = builder.minBufferTime;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String destination() {
        return this.destination;
    }

    public DashIsoEncryptionSettings encryption() {
        return this.encryption;
    }

    public Integer fragmentLength() {
        return this.fragmentLength;
    }

    public DashIsoHbbtvCompliance hbbtvCompliance() {
        return DashIsoHbbtvCompliance.fromValue(this.hbbtvCompliance);
    }

    public String hbbtvComplianceAsString() {
        return this.hbbtvCompliance;
    }

    public Integer minBufferTime() {
        return this.minBufferTime;
    }

    public DashIsoSegmentControl segmentControl() {
        return DashIsoSegmentControl.fromValue(this.segmentControl);
    }

    public String segmentControlAsString() {
        return this.segmentControl;
    }

    public Integer segmentLength() {
        return this.segmentLength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.hbbtvComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashIsoGroupSettings)) {
            return false;
        }
        DashIsoGroupSettings other = (DashIsoGroupSettings)obj;
        return Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.hbbtvComplianceAsString(), other.hbbtvComplianceAsString()) && Objects.equals(this.minBufferTime(), other.minBufferTime()) && Objects.equals(this.segmentControlAsString(), other.segmentControlAsString()) && Objects.equals(this.segmentLength(), other.segmentLength());
    }

    public String toString() {
        return ToString.builder((String)"DashIsoGroupSettings").add("BaseUrl", (Object)this.baseUrl()).add("Destination", (Object)this.destination()).add("Encryption", (Object)this.encryption()).add("FragmentLength", (Object)this.fragmentLength()).add("HbbtvCompliance", (Object)this.hbbtvComplianceAsString()).add("MinBufferTime", (Object)this.minBufferTime()).add("SegmentControl", (Object)this.segmentControlAsString()).add("SegmentLength", (Object)this.segmentLength()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "FragmentLength": {
                return Optional.ofNullable(clazz.cast(this.fragmentLength()));
            }
            case "HbbtvCompliance": {
                return Optional.ofNullable(clazz.cast(this.hbbtvComplianceAsString()));
            }
            case "MinBufferTime": {
                return Optional.ofNullable(clazz.cast(this.minBufferTime()));
            }
            case "SegmentControl": {
                return Optional.ofNullable(clazz.cast(this.segmentControlAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DashIsoGroupSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseUrl;
        private String destination;
        private DashIsoEncryptionSettings encryption;
        private Integer fragmentLength;
        private String hbbtvCompliance;
        private Integer minBufferTime;
        private String segmentControl;
        private Integer segmentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(DashIsoGroupSettings model) {
            this.baseUrl(model.baseUrl);
            this.destination(model.destination);
            this.encryption(model.encryption);
            this.fragmentLength(model.fragmentLength);
            this.hbbtvCompliance(model.hbbtvCompliance);
            this.minBufferTime(model.minBufferTime);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final DashIsoEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashIsoEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashIsoEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getHbbtvCompliance() {
            return this.hbbtvCompliance;
        }

        @Override
        public final Builder hbbtvCompliance(String hbbtvCompliance) {
            this.hbbtvCompliance = hbbtvCompliance;
            return this;
        }

        @Override
        public final Builder hbbtvCompliance(DashIsoHbbtvCompliance hbbtvCompliance) {
            this.hbbtvCompliance(hbbtvCompliance.toString());
            return this;
        }

        public final void setHbbtvCompliance(String hbbtvCompliance) {
            this.hbbtvCompliance = hbbtvCompliance;
        }

        public final Integer getMinBufferTime() {
            return this.minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        public final String getSegmentControl() {
            return this.segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(DashIsoSegmentControl segmentControl) {
            this.segmentControl(segmentControl.toString());
            return this;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public DashIsoGroupSettings build() {
            return new DashIsoGroupSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DashIsoGroupSettings> {
        public Builder baseUrl(String var1);

        public Builder destination(String var1);

        public Builder encryption(DashIsoEncryptionSettings var1);

        default public Builder encryption(Consumer<DashIsoEncryptionSettings.Builder> encryption) {
            return this.encryption((DashIsoEncryptionSettings)((DashIsoEncryptionSettings.Builder)DashIsoEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder fragmentLength(Integer var1);

        public Builder hbbtvCompliance(String var1);

        public Builder hbbtvCompliance(DashIsoHbbtvCompliance var1);

        public Builder minBufferTime(Integer var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(DashIsoSegmentControl var1);

        public Builder segmentLength(Integer var1);
    }
}

