/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.BurninDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDestinationType;
import software.amazon.awssdk.services.mediaconvert.model.DvbSubDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.SccDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.TeletextDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.TtmlDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.transform.CaptionDestinationSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaptionDestinationSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, CaptionDestinationSettings> {
    private final BurninDestinationSettings burninDestinationSettings;
    private final String destinationType;
    private final DvbSubDestinationSettings dvbSubDestinationSettings;
    private final SccDestinationSettings sccDestinationSettings;
    private final TeletextDestinationSettings teletextDestinationSettings;
    private final TtmlDestinationSettings ttmlDestinationSettings;

    private CaptionDestinationSettings(BuilderImpl builder) {
        this.burninDestinationSettings = builder.burninDestinationSettings;
        this.destinationType = builder.destinationType;
        this.dvbSubDestinationSettings = builder.dvbSubDestinationSettings;
        this.sccDestinationSettings = builder.sccDestinationSettings;
        this.teletextDestinationSettings = builder.teletextDestinationSettings;
        this.ttmlDestinationSettings = builder.ttmlDestinationSettings;
    }

    public BurninDestinationSettings burninDestinationSettings() {
        return this.burninDestinationSettings;
    }

    public CaptionDestinationType destinationType() {
        return CaptionDestinationType.fromValue(this.destinationType);
    }

    public String destinationTypeAsString() {
        return this.destinationType;
    }

    public DvbSubDestinationSettings dvbSubDestinationSettings() {
        return this.dvbSubDestinationSettings;
    }

    public SccDestinationSettings sccDestinationSettings() {
        return this.sccDestinationSettings;
    }

    public TeletextDestinationSettings teletextDestinationSettings() {
        return this.teletextDestinationSettings;
    }

    public TtmlDestinationSettings ttmlDestinationSettings() {
        return this.ttmlDestinationSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.burninDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSubDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sccDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.teletextDestinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttmlDestinationSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDestinationSettings)) {
            return false;
        }
        CaptionDestinationSettings other = (CaptionDestinationSettings)obj;
        return Objects.equals(this.burninDestinationSettings(), other.burninDestinationSettings()) && Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.dvbSubDestinationSettings(), other.dvbSubDestinationSettings()) && Objects.equals(this.sccDestinationSettings(), other.sccDestinationSettings()) && Objects.equals(this.teletextDestinationSettings(), other.teletextDestinationSettings()) && Objects.equals(this.ttmlDestinationSettings(), other.ttmlDestinationSettings());
    }

    public String toString() {
        return ToString.builder((String)"CaptionDestinationSettings").add("BurninDestinationSettings", (Object)this.burninDestinationSettings()).add("DestinationType", (Object)this.destinationTypeAsString()).add("DvbSubDestinationSettings", (Object)this.dvbSubDestinationSettings()).add("SccDestinationSettings", (Object)this.sccDestinationSettings()).add("TeletextDestinationSettings", (Object)this.teletextDestinationSettings()).add("TtmlDestinationSettings", (Object)this.ttmlDestinationSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BurninDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.burninDestinationSettings()));
            }
            case "DestinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "DvbSubDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.dvbSubDestinationSettings()));
            }
            case "SccDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.sccDestinationSettings()));
            }
            case "TeletextDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.teletextDestinationSettings()));
            }
            case "TtmlDestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.ttmlDestinationSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CaptionDestinationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BurninDestinationSettings burninDestinationSettings;
        private String destinationType;
        private DvbSubDestinationSettings dvbSubDestinationSettings;
        private SccDestinationSettings sccDestinationSettings;
        private TeletextDestinationSettings teletextDestinationSettings;
        private TtmlDestinationSettings ttmlDestinationSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDestinationSettings model) {
            this.burninDestinationSettings(model.burninDestinationSettings);
            this.destinationType(model.destinationType);
            this.dvbSubDestinationSettings(model.dvbSubDestinationSettings);
            this.sccDestinationSettings(model.sccDestinationSettings);
            this.teletextDestinationSettings(model.teletextDestinationSettings);
            this.ttmlDestinationSettings(model.ttmlDestinationSettings);
        }

        public final BurninDestinationSettings.Builder getBurninDestinationSettings() {
            return this.burninDestinationSettings != null ? this.burninDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder burninDestinationSettings(BurninDestinationSettings burninDestinationSettings) {
            this.burninDestinationSettings = burninDestinationSettings;
            return this;
        }

        public final void setBurninDestinationSettings(BurninDestinationSettings.BuilderImpl burninDestinationSettings) {
            this.burninDestinationSettings = burninDestinationSettings != null ? burninDestinationSettings.build() : null;
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(CaptionDestinationType destinationType) {
            this.destinationType(destinationType.toString());
            return this;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        public final DvbSubDestinationSettings.Builder getDvbSubDestinationSettings() {
            return this.dvbSubDestinationSettings != null ? this.dvbSubDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSubDestinationSettings(DvbSubDestinationSettings dvbSubDestinationSettings) {
            this.dvbSubDestinationSettings = dvbSubDestinationSettings;
            return this;
        }

        public final void setDvbSubDestinationSettings(DvbSubDestinationSettings.BuilderImpl dvbSubDestinationSettings) {
            this.dvbSubDestinationSettings = dvbSubDestinationSettings != null ? dvbSubDestinationSettings.build() : null;
        }

        public final SccDestinationSettings.Builder getSccDestinationSettings() {
            return this.sccDestinationSettings != null ? this.sccDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder sccDestinationSettings(SccDestinationSettings sccDestinationSettings) {
            this.sccDestinationSettings = sccDestinationSettings;
            return this;
        }

        public final void setSccDestinationSettings(SccDestinationSettings.BuilderImpl sccDestinationSettings) {
            this.sccDestinationSettings = sccDestinationSettings != null ? sccDestinationSettings.build() : null;
        }

        public final TeletextDestinationSettings.Builder getTeletextDestinationSettings() {
            return this.teletextDestinationSettings != null ? this.teletextDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder teletextDestinationSettings(TeletextDestinationSettings teletextDestinationSettings) {
            this.teletextDestinationSettings = teletextDestinationSettings;
            return this;
        }

        public final void setTeletextDestinationSettings(TeletextDestinationSettings.BuilderImpl teletextDestinationSettings) {
            this.teletextDestinationSettings = teletextDestinationSettings != null ? teletextDestinationSettings.build() : null;
        }

        public final TtmlDestinationSettings.Builder getTtmlDestinationSettings() {
            return this.ttmlDestinationSettings != null ? this.ttmlDestinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder ttmlDestinationSettings(TtmlDestinationSettings ttmlDestinationSettings) {
            this.ttmlDestinationSettings = ttmlDestinationSettings;
            return this;
        }

        public final void setTtmlDestinationSettings(TtmlDestinationSettings.BuilderImpl ttmlDestinationSettings) {
            this.ttmlDestinationSettings = ttmlDestinationSettings != null ? ttmlDestinationSettings.build() : null;
        }

        public CaptionDestinationSettings build() {
            return new CaptionDestinationSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CaptionDestinationSettings> {
        public Builder burninDestinationSettings(BurninDestinationSettings var1);

        default public Builder burninDestinationSettings(Consumer<BurninDestinationSettings.Builder> burninDestinationSettings) {
            return this.burninDestinationSettings((BurninDestinationSettings)((BurninDestinationSettings.Builder)BurninDestinationSettings.builder().applyMutation(burninDestinationSettings)).build());
        }

        public Builder destinationType(String var1);

        public Builder destinationType(CaptionDestinationType var1);

        public Builder dvbSubDestinationSettings(DvbSubDestinationSettings var1);

        default public Builder dvbSubDestinationSettings(Consumer<DvbSubDestinationSettings.Builder> dvbSubDestinationSettings) {
            return this.dvbSubDestinationSettings((DvbSubDestinationSettings)((DvbSubDestinationSettings.Builder)DvbSubDestinationSettings.builder().applyMutation(dvbSubDestinationSettings)).build());
        }

        public Builder sccDestinationSettings(SccDestinationSettings var1);

        default public Builder sccDestinationSettings(Consumer<SccDestinationSettings.Builder> sccDestinationSettings) {
            return this.sccDestinationSettings((SccDestinationSettings)((SccDestinationSettings.Builder)SccDestinationSettings.builder().applyMutation(sccDestinationSettings)).build());
        }

        public Builder teletextDestinationSettings(TeletextDestinationSettings var1);

        default public Builder teletextDestinationSettings(Consumer<TeletextDestinationSettings.Builder> teletextDestinationSettings) {
            return this.teletextDestinationSettings((TeletextDestinationSettings)((TeletextDestinationSettings.Builder)TeletextDestinationSettings.builder().applyMutation(teletextDestinationSettings)).build());
        }

        public Builder ttmlDestinationSettings(TtmlDestinationSettings var1);

        default public Builder ttmlDestinationSettings(Consumer<TtmlDestinationSettings.Builder> ttmlDestinationSettings) {
            return this.ttmlDestinationSettings((TtmlDestinationSettings)((TtmlDestinationSettings.Builder)TtmlDestinationSettings.builder().applyMutation(ttmlDestinationSettings)).build());
        }
    }
}

