/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.AudioDefaultSelection;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelectorType;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.services.mediaconvert.model.ListOf__integerCopier;
import software.amazon.awssdk.services.mediaconvert.model.RemixSettings;
import software.amazon.awssdk.services.mediaconvert.transform.AudioSelectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioSelector
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioSelector> {
    private final String defaultSelection;
    private final String externalAudioFileInput;
    private final String languageCode;
    private final Integer offset;
    private final List<Integer> pids;
    private final Integer programSelection;
    private final RemixSettings remixSettings;
    private final String selectorType;
    private final List<Integer> tracks;

    private AudioSelector(BuilderImpl builder) {
        this.defaultSelection = builder.defaultSelection;
        this.externalAudioFileInput = builder.externalAudioFileInput;
        this.languageCode = builder.languageCode;
        this.offset = builder.offset;
        this.pids = builder.pids;
        this.programSelection = builder.programSelection;
        this.remixSettings = builder.remixSettings;
        this.selectorType = builder.selectorType;
        this.tracks = builder.tracks;
    }

    public AudioDefaultSelection defaultSelection() {
        return AudioDefaultSelection.fromValue(this.defaultSelection);
    }

    public String defaultSelectionAsString() {
        return this.defaultSelection;
    }

    public String externalAudioFileInput() {
        return this.externalAudioFileInput;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public Integer offset() {
        return this.offset;
    }

    public List<Integer> pids() {
        return this.pids;
    }

    public Integer programSelection() {
        return this.programSelection;
    }

    public RemixSettings remixSettings() {
        return this.remixSettings;
    }

    public AudioSelectorType selectorType() {
        return AudioSelectorType.fromValue(this.selectorType);
    }

    public String selectorTypeAsString() {
        return this.selectorType;
    }

    public List<Integer> tracks() {
        return this.tracks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalAudioFileInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.pids());
        hashCode = 31 * hashCode + Objects.hashCode(this.programSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.remixSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelector)) {
            return false;
        }
        AudioSelector other = (AudioSelector)obj;
        return Objects.equals(this.defaultSelectionAsString(), other.defaultSelectionAsString()) && Objects.equals(this.externalAudioFileInput(), other.externalAudioFileInput()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.offset(), other.offset()) && Objects.equals(this.pids(), other.pids()) && Objects.equals(this.programSelection(), other.programSelection()) && Objects.equals(this.remixSettings(), other.remixSettings()) && Objects.equals(this.selectorTypeAsString(), other.selectorTypeAsString()) && Objects.equals(this.tracks(), other.tracks());
    }

    public String toString() {
        return ToString.builder((String)"AudioSelector").add("DefaultSelection", (Object)this.defaultSelectionAsString()).add("ExternalAudioFileInput", (Object)this.externalAudioFileInput()).add("LanguageCode", (Object)this.languageCodeAsString()).add("Offset", (Object)this.offset()).add("Pids", this.pids()).add("ProgramSelection", (Object)this.programSelection()).add("RemixSettings", (Object)this.remixSettings()).add("SelectorType", (Object)this.selectorTypeAsString()).add("Tracks", this.tracks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultSelection": {
                return Optional.ofNullable(clazz.cast(this.defaultSelectionAsString()));
            }
            case "ExternalAudioFileInput": {
                return Optional.ofNullable(clazz.cast(this.externalAudioFileInput()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "Offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "Pids": {
                return Optional.ofNullable(clazz.cast(this.pids()));
            }
            case "ProgramSelection": {
                return Optional.ofNullable(clazz.cast(this.programSelection()));
            }
            case "RemixSettings": {
                return Optional.ofNullable(clazz.cast(this.remixSettings()));
            }
            case "SelectorType": {
                return Optional.ofNullable(clazz.cast(this.selectorTypeAsString()));
            }
            case "Tracks": {
                return Optional.ofNullable(clazz.cast(this.tracks()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultSelection;
        private String externalAudioFileInput;
        private String languageCode;
        private Integer offset;
        private List<Integer> pids = DefaultSdkAutoConstructList.getInstance();
        private Integer programSelection;
        private RemixSettings remixSettings;
        private String selectorType;
        private List<Integer> tracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelector model) {
            this.defaultSelection(model.defaultSelection);
            this.externalAudioFileInput(model.externalAudioFileInput);
            this.languageCode(model.languageCode);
            this.offset(model.offset);
            this.pids(model.pids);
            this.programSelection(model.programSelection);
            this.remixSettings(model.remixSettings);
            this.selectorType(model.selectorType);
            this.tracks(model.tracks);
        }

        public final String getDefaultSelection() {
            return this.defaultSelection;
        }

        @Override
        public final Builder defaultSelection(String defaultSelection) {
            this.defaultSelection = defaultSelection;
            return this;
        }

        @Override
        public final Builder defaultSelection(AudioDefaultSelection defaultSelection) {
            this.defaultSelection(defaultSelection.toString());
            return this;
        }

        public final void setDefaultSelection(String defaultSelection) {
            this.defaultSelection = defaultSelection;
        }

        public final String getExternalAudioFileInput() {
            return this.externalAudioFileInput;
        }

        @Override
        public final Builder externalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
            return this;
        }

        public final void setExternalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        public final Collection<Integer> getPids() {
            return this.pids;
        }

        @Override
        public final Builder pids(Collection<Integer> pids) {
            this.pids = ListOf__integerCopier.copy(pids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pids(Integer ... pids) {
            this.pids(Arrays.asList(pids));
            return this;
        }

        public final void setPids(Collection<Integer> pids) {
            this.pids = ListOf__integerCopier.copy(pids);
        }

        public final Integer getProgramSelection() {
            return this.programSelection;
        }

        @Override
        public final Builder programSelection(Integer programSelection) {
            this.programSelection = programSelection;
            return this;
        }

        public final void setProgramSelection(Integer programSelection) {
            this.programSelection = programSelection;
        }

        public final RemixSettings.Builder getRemixSettings() {
            return this.remixSettings != null ? this.remixSettings.toBuilder() : null;
        }

        @Override
        public final Builder remixSettings(RemixSettings remixSettings) {
            this.remixSettings = remixSettings;
            return this;
        }

        public final void setRemixSettings(RemixSettings.BuilderImpl remixSettings) {
            this.remixSettings = remixSettings != null ? remixSettings.build() : null;
        }

        public final String getSelectorType() {
            return this.selectorType;
        }

        @Override
        public final Builder selectorType(String selectorType) {
            this.selectorType = selectorType;
            return this;
        }

        @Override
        public final Builder selectorType(AudioSelectorType selectorType) {
            this.selectorType(selectorType.toString());
            return this;
        }

        public final void setSelectorType(String selectorType) {
            this.selectorType = selectorType;
        }

        public final Collection<Integer> getTracks() {
            return this.tracks;
        }

        @Override
        public final Builder tracks(Collection<Integer> tracks) {
            this.tracks = ListOf__integerCopier.copy(tracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Integer ... tracks) {
            this.tracks(Arrays.asList(tracks));
            return this;
        }

        public final void setTracks(Collection<Integer> tracks) {
            this.tracks = ListOf__integerCopier.copy(tracks);
        }

        public AudioSelector build() {
            return new AudioSelector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioSelector> {
        public Builder defaultSelection(String var1);

        public Builder defaultSelection(AudioDefaultSelection var1);

        public Builder externalAudioFileInput(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder offset(Integer var1);

        public Builder pids(Collection<Integer> var1);

        public Builder pids(Integer ... var1);

        public Builder programSelection(Integer var1);

        public Builder remixSettings(RemixSettings var1);

        default public Builder remixSettings(Consumer<RemixSettings.Builder> remixSettings) {
            return this.remixSettings((RemixSettings)((RemixSettings.Builder)RemixSettings.builder().applyMutation(remixSettings)).build());
        }

        public Builder selectorType(String var1);

        public Builder selectorType(AudioSelectorType var1);

        public Builder tracks(Collection<Integer> var1);

        public Builder tracks(Integer ... var1);
    }
}

