/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.MediaConvertClient;
import software.amazon.awssdk.services.mediaconvert.model.BadRequestException;
import software.amazon.awssdk.services.mediaconvert.model.CancelJobRequest;
import software.amazon.awssdk.services.mediaconvert.model.CancelJobResponse;
import software.amazon.awssdk.services.mediaconvert.model.ConflictException;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreatePresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreatePresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreateQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreateQueueResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeleteJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeleteJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeletePresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeletePresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeleteQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeleteQueueResponse;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.mediaconvert.model.ForbiddenException;
import software.amazon.awssdk.services.mediaconvert.model.GetJobRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetJobResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetPresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetPresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetQueueResponse;
import software.amazon.awssdk.services.mediaconvert.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListJobsResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListPresetsResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertException;
import software.amazon.awssdk.services.mediaconvert.model.NotFoundException;
import software.amazon.awssdk.services.mediaconvert.model.TooManyRequestsException;
import software.amazon.awssdk.services.mediaconvert.model.UpdateJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.UpdateJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.UpdatePresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.UpdatePresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.UpdateQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.UpdateQueueResponse;
import software.amazon.awssdk.services.mediaconvert.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CancelJobResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CreateJobResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CreateJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CreateJobTemplateResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CreatePresetRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CreatePresetResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CreateQueueRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.CreateQueueResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.DeleteJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.DeleteJobTemplateResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.DeletePresetRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.DeletePresetResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.DeleteQueueRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.DeleteQueueResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.DescribeEndpointsResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.GetJobRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.GetJobResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.GetJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.GetJobTemplateResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.GetPresetRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.GetPresetResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.GetQueueRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.GetQueueResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ListJobTemplatesRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ListJobTemplatesResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ListJobsResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ListPresetsRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ListPresetsResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ListQueuesRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.ListQueuesResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.UpdateJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.UpdateJobTemplateResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.UpdatePresetRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.UpdatePresetResponseUnmarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.UpdateQueueRequestMarshaller;
import software.amazon.awssdk.services.mediaconvert.transform.UpdateQueueResponseUnmarshaller;

@SdkInternalApi
final class DefaultMediaConvertClient
implements MediaConvertClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMediaConvertClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "mediaconvert";
    }

    @Override
    public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJobResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CancelJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelJobRequest).withMarshaller((Marshaller)new CancelJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createJobRequest).withMarshaller((Marshaller)new CreateJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateJobTemplateResponse createJobTemplate(CreateJobTemplateRequest createJobTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobTemplateResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateJobTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createJobTemplateRequest).withMarshaller((Marshaller)new CreateJobTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreatePresetResponse createPreset(CreatePresetRequest createPresetRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePresetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreatePresetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPresetRequest).withMarshaller((Marshaller)new CreatePresetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateQueueResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createQueueRequest).withMarshaller((Marshaller)new CreateQueueRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteJobTemplateResponse deleteJobTemplate(DeleteJobTemplateRequest deleteJobTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteJobTemplateResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteJobTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteJobTemplateRequest).withMarshaller((Marshaller)new DeleteJobTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeletePresetResponse deletePreset(DeletePresetRequest deletePresetRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePresetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeletePresetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePresetRequest).withMarshaller((Marshaller)new DeletePresetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteQueueResponse deleteQueue(DeleteQueueRequest deleteQueueRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteQueueResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteQueueRequest).withMarshaller((Marshaller)new DeleteQueueRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEndpointsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEndpointsRequest).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetJobResponse getJob(GetJobRequest getJobRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobRequest).withMarshaller((Marshaller)new GetJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetJobTemplateResponse getJobTemplate(GetJobTemplateRequest getJobTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobTemplateResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetJobTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getJobTemplateRequest).withMarshaller((Marshaller)new GetJobTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetPresetResponse getPreset(GetPresetRequest getPresetRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPresetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetPresetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPresetRequest).withMarshaller((Marshaller)new GetPresetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetQueueResponse getQueue(GetQueueRequest getQueueRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetQueueResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQueueRequest).withMarshaller((Marshaller)new GetQueueRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListJobTemplatesResponse listJobTemplates(ListJobTemplatesRequest listJobTemplatesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobTemplatesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListJobTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobTemplatesRequest).withMarshaller((Marshaller)new ListJobTemplatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobsRequest).withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListPresetsResponse listPresets(ListPresetsRequest listPresetsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPresetsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListPresetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPresetsRequest).withMarshaller((Marshaller)new ListPresetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListQueuesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQueuesRequest).withMarshaller((Marshaller)new ListQueuesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateJobTemplateResponse updateJobTemplate(UpdateJobTemplateRequest updateJobTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateJobTemplateResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateJobTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateJobTemplateRequest).withMarshaller((Marshaller)new UpdateJobTemplateRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdatePresetResponse updatePreset(UpdatePresetRequest updatePresetRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePresetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdatePresetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePresetRequest).withMarshaller((Marshaller)new UpdatePresetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateQueueResponse updateQueue(UpdateQueueRequest updateQueueRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateQueueResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateQueueRequest).withMarshaller((Marshaller)new UpdateQueueRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(MediaConvertException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(ConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

