/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Timing;

public class TimingUnmarshaller
implements Unmarshaller<Timing, JsonUnmarshallerContext> {
    private static final TimingUnmarshaller INSTANCE = new TimingUnmarshaller();

    public Timing unmarshall(JsonUnmarshallerContext context) throws Exception {
        Timing.Builder timingBuilder = Timing.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("finishTime", targetDepth)) {
                    context.nextToken();
                    timingBuilder.finishTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("startTime", targetDepth)) {
                    context.nextToken();
                    timingBuilder.startTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("submitTime", targetDepth)) {
                    context.nextToken();
                    timingBuilder.submitTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Timing)timingBuilder.build();
    }

    public static TimingUnmarshaller getInstance() {
        return INSTANCE;
    }
}

