/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.TeletextSourceSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TeletextSourceSettingsMarshaller {
    private static final MarshallingInfo<String> PAGENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pageNumber").isBinary(false).build();
    private static final TeletextSourceSettingsMarshaller INSTANCE = new TeletextSourceSettingsMarshaller();

    private TeletextSourceSettingsMarshaller() {
    }

    public static TeletextSourceSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TeletextSourceSettings teletextSourceSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)teletextSourceSettings, (String)"teletextSourceSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)teletextSourceSettings.pageNumber(), PAGENUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

