/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.MovSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MovSettingsMarshaller {
    private static final MarshallingInfo<String> CLAPATOM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clapAtom").isBinary(false).build();
    private static final MarshallingInfo<String> CSLGATOM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cslgAtom").isBinary(false).build();
    private static final MarshallingInfo<String> MPEG2FOURCCCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mpeg2FourCCControl").isBinary(false).build();
    private static final MarshallingInfo<String> PADDINGCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("paddingControl").isBinary(false).build();
    private static final MarshallingInfo<String> REFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reference").isBinary(false).build();
    private static final MovSettingsMarshaller INSTANCE = new MovSettingsMarshaller();

    private MovSettingsMarshaller() {
    }

    public static MovSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MovSettings movSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)movSettings, (String)"movSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)movSettings.clapAtomAsString(), CLAPATOM_BINDING);
            protocolMarshaller.marshall((Object)movSettings.cslgAtomAsString(), CSLGATOM_BINDING);
            protocolMarshaller.marshall((Object)movSettings.mpeg2FourCCControlAsString(), MPEG2FOURCCCONTROL_BINDING);
            protocolMarshaller.marshall((Object)movSettings.paddingControlAsString(), PADDINGCONTROL_BINDING);
            protocolMarshaller.marshall((Object)movSettings.referenceAsString(), REFERENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

