/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediaconvert.model.Eac3Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Eac3SettingsMarshaller {
    private static final MarshallingInfo<String> ATTENUATIONCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attenuationControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> BITSTREAMMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitstreamMode").isBinary(false).build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").isBinary(false).build();
    private static final MarshallingInfo<String> DCFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dcFilter").isBinary(false).build();
    private static final MarshallingInfo<Integer> DIALNORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dialnorm").isBinary(false).build();
    private static final MarshallingInfo<String> DYNAMICRANGECOMPRESSIONLINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamicRangeCompressionLine").isBinary(false).build();
    private static final MarshallingInfo<String> DYNAMICRANGECOMPRESSIONRF_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamicRangeCompressionRf").isBinary(false).build();
    private static final MarshallingInfo<String> LFECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lfeControl").isBinary(false).build();
    private static final MarshallingInfo<String> LFEFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lfeFilter").isBinary(false).build();
    private static final MarshallingInfo<Double> LOROCENTERMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loRoCenterMixLevel").isBinary(false).build();
    private static final MarshallingInfo<Double> LOROSURROUNDMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loRoSurroundMixLevel").isBinary(false).build();
    private static final MarshallingInfo<Double> LTRTCENTERMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ltRtCenterMixLevel").isBinary(false).build();
    private static final MarshallingInfo<Double> LTRTSURROUNDMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ltRtSurroundMixLevel").isBinary(false).build();
    private static final MarshallingInfo<String> METADATACONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadataControl").isBinary(false).build();
    private static final MarshallingInfo<String> PASSTHROUGHCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passthroughControl").isBinary(false).build();
    private static final MarshallingInfo<String> PHASECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phaseControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").isBinary(false).build();
    private static final MarshallingInfo<String> STEREODOWNMIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stereoDownmix").isBinary(false).build();
    private static final MarshallingInfo<String> SURROUNDEXMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("surroundExMode").isBinary(false).build();
    private static final MarshallingInfo<String> SURROUNDMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("surroundMode").isBinary(false).build();
    private static final Eac3SettingsMarshaller INSTANCE = new Eac3SettingsMarshaller();

    private Eac3SettingsMarshaller() {
    }

    public static Eac3SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Eac3Settings eac3Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eac3Settings, (String)"eac3Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eac3Settings.attenuationControlAsString(), ATTENUATIONCONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.bitstreamModeAsString(), BITSTREAMMODE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.codingModeAsString(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.dcFilterAsString(), DCFILTER_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.dialnorm(), DIALNORM_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.dynamicRangeCompressionLineAsString(), DYNAMICRANGECOMPRESSIONLINE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.dynamicRangeCompressionRfAsString(), DYNAMICRANGECOMPRESSIONRF_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.lfeControlAsString(), LFECONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.lfeFilterAsString(), LFEFILTER_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.loRoCenterMixLevel(), LOROCENTERMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.loRoSurroundMixLevel(), LOROSURROUNDMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.ltRtCenterMixLevel(), LTRTCENTERMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.ltRtSurroundMixLevel(), LTRTSURROUNDMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.metadataControlAsString(), METADATACONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.passthroughControlAsString(), PASSTHROUGHCONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.phaseControlAsString(), PHASECONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.sampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.stereoDownmixAsString(), STEREODOWNMIX_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.surroundExModeAsString(), SURROUNDEXMODE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.surroundModeAsString(), SURROUNDMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

