/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AudioDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AudioDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUDIONORMALIZATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioNormalizationSettings").isBinary(false).build();
    private static final MarshallingInfo<String> AUDIOSOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioSourceName").isBinary(false).build();
    private static final MarshallingInfo<Integer> AUDIOTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioType").isBinary(false).build();
    private static final MarshallingInfo<String> AUDIOTYPECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioTypeControl").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CODECSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codecSettings").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCode").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCodeControl").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REMIXSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remixSettings").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamName").isBinary(false).build();
    private static final AudioDescriptionMarshaller INSTANCE = new AudioDescriptionMarshaller();

    private AudioDescriptionMarshaller() {
    }

    public static AudioDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AudioDescription audioDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)audioDescription, (String)"audioDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)audioDescription.audioNormalizationSettings(), AUDIONORMALIZATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.audioSourceName(), AUDIOSOURCENAME_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.audioType(), AUDIOTYPE_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.audioTypeControlAsString(), AUDIOTYPECONTROL_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.codecSettings(), CODECSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.languageCodeAsString(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.languageCodeControlAsString(), LANGUAGECODECONTROL_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.remixSettings(), REMIXSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)audioDescription.streamName(), STREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

