/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.ColorSpace;
import software.amazon.awssdk.services.mediaconvert.model.ColorSpaceUsage;
import software.amazon.awssdk.services.mediaconvert.model.Hdr10Metadata;
import software.amazon.awssdk.services.mediaconvert.transform.VideoSelectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VideoSelector
implements StructuredPojo,
ToCopyableBuilder<Builder, VideoSelector> {
    private final String colorSpace;
    private final String colorSpaceUsage;
    private final Hdr10Metadata hdr10Metadata;
    private final Integer pid;
    private final Integer programNumber;

    private VideoSelector(BuilderImpl builder) {
        this.colorSpace = builder.colorSpace;
        this.colorSpaceUsage = builder.colorSpaceUsage;
        this.hdr10Metadata = builder.hdr10Metadata;
        this.pid = builder.pid;
        this.programNumber = builder.programNumber;
    }

    public ColorSpace colorSpace() {
        return ColorSpace.fromValue(this.colorSpace);
    }

    public String colorSpaceAsString() {
        return this.colorSpace;
    }

    public ColorSpaceUsage colorSpaceUsage() {
        return ColorSpaceUsage.fromValue(this.colorSpaceUsage);
    }

    public String colorSpaceUsageAsString() {
        return this.colorSpaceUsage;
    }

    public Hdr10Metadata hdr10Metadata() {
        return this.hdr10Metadata;
    }

    public Integer pid() {
        return this.pid;
    }

    public Integer programNumber() {
        return this.programNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hdr10Metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelector)) {
            return false;
        }
        VideoSelector other = (VideoSelector)obj;
        return Objects.equals(this.colorSpaceAsString(), other.colorSpaceAsString()) && Objects.equals(this.colorSpaceUsageAsString(), other.colorSpaceUsageAsString()) && Objects.equals(this.hdr10Metadata(), other.hdr10Metadata()) && Objects.equals(this.pid(), other.pid()) && Objects.equals(this.programNumber(), other.programNumber());
    }

    public String toString() {
        return ToString.builder((String)"VideoSelector").add("ColorSpace", (Object)this.colorSpaceAsString()).add("ColorSpaceUsage", (Object)this.colorSpaceUsageAsString()).add("Hdr10Metadata", (Object)this.hdr10Metadata()).add("Pid", (Object)this.pid()).add("ProgramNumber", (Object)this.programNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColorSpace": {
                return Optional.of(clazz.cast(this.colorSpaceAsString()));
            }
            case "ColorSpaceUsage": {
                return Optional.of(clazz.cast(this.colorSpaceUsageAsString()));
            }
            case "Hdr10Metadata": {
                return Optional.of(clazz.cast(this.hdr10Metadata()));
            }
            case "Pid": {
                return Optional.of(clazz.cast(this.pid()));
            }
            case "ProgramNumber": {
                return Optional.of(clazz.cast(this.programNumber()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String colorSpace;
        private String colorSpaceUsage;
        private Hdr10Metadata hdr10Metadata;
        private Integer pid;
        private Integer programNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelector model) {
            this.colorSpace(model.colorSpace);
            this.colorSpaceUsage(model.colorSpaceUsage);
            this.hdr10Metadata(model.hdr10Metadata);
            this.pid(model.pid);
            this.programNumber(model.programNumber);
        }

        public final String getColorSpace() {
            return this.colorSpace;
        }

        @Override
        public final Builder colorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @Override
        public final Builder colorSpace(ColorSpace colorSpace) {
            this.colorSpace(colorSpace.toString());
            return this;
        }

        public final void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        public final String getColorSpaceUsage() {
            return this.colorSpaceUsage;
        }

        @Override
        public final Builder colorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
            return this;
        }

        @Override
        public final Builder colorSpaceUsage(ColorSpaceUsage colorSpaceUsage) {
            this.colorSpaceUsage(colorSpaceUsage.toString());
            return this;
        }

        public final void setColorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
        }

        public final Hdr10Metadata.Builder getHdr10Metadata() {
            return this.hdr10Metadata != null ? this.hdr10Metadata.toBuilder() : null;
        }

        @Override
        public final Builder hdr10Metadata(Hdr10Metadata hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata;
            return this;
        }

        public final void setHdr10Metadata(Hdr10Metadata.BuilderImpl hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata != null ? hdr10Metadata.build() : null;
        }

        public final Integer getPid() {
            return this.pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        public VideoSelector build() {
            return new VideoSelector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VideoSelector> {
        public Builder colorSpace(String var1);

        public Builder colorSpace(ColorSpace var1);

        public Builder colorSpaceUsage(String var1);

        public Builder colorSpaceUsage(ColorSpaceUsage var1);

        public Builder hdr10Metadata(Hdr10Metadata var1);

        default public Builder hdr10Metadata(Consumer<Hdr10Metadata.Builder> hdr10Metadata) {
            return this.hdr10Metadata((Hdr10Metadata)((Hdr10Metadata.Builder)Hdr10Metadata.builder().apply(hdr10Metadata)).build());
        }

        public Builder pid(Integer var1);

        public Builder programNumber(Integer var1);
    }
}

