/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.SccDestinationFramerate;
import software.amazon.awssdk.services.mediaconvert.transform.SccDestinationSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SccDestinationSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, SccDestinationSettings> {
    private final String framerate;

    private SccDestinationSettings(BuilderImpl builder) {
        this.framerate = builder.framerate;
    }

    public SccDestinationFramerate framerate() {
        return SccDestinationFramerate.fromValue(this.framerate);
    }

    public String framerateAsString() {
        return this.framerate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SccDestinationSettings)) {
            return false;
        }
        SccDestinationSettings other = (SccDestinationSettings)obj;
        return Objects.equals(this.framerateAsString(), other.framerateAsString());
    }

    public String toString() {
        return ToString.builder((String)"SccDestinationSettings").add("Framerate", (Object)this.framerateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Framerate": {
                return Optional.of(clazz.cast(this.framerateAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SccDestinationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String framerate;

        private BuilderImpl() {
        }

        private BuilderImpl(SccDestinationSettings model) {
            this.framerate(model.framerate);
        }

        public final String getFramerate() {
            return this.framerate;
        }

        @Override
        public final Builder framerate(String framerate) {
            this.framerate = framerate;
            return this;
        }

        @Override
        public final Builder framerate(SccDestinationFramerate framerate) {
            this.framerate(framerate.toString());
            return this;
        }

        public final void setFramerate(String framerate) {
            this.framerate = framerate;
        }

        public SccDestinationSettings build() {
            return new SccDestinationSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SccDestinationSettings> {
        public Builder framerate(String var1);

        public Builder framerate(SccDestinationFramerate var1);
    }
}

