/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.ProresCodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.ProresFramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.ProresFramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.ProresInterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.ProresParControl;
import software.amazon.awssdk.services.mediaconvert.model.ProresSlowPal;
import software.amazon.awssdk.services.mediaconvert.model.ProresTelecine;
import software.amazon.awssdk.services.mediaconvert.transform.ProresSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProresSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, ProresSettings> {
    private final String codecProfile;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String interlaceMode;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String slowPal;
    private final String telecine;

    private ProresSettings(BuilderImpl builder) {
        this.codecProfile = builder.codecProfile;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.interlaceMode = builder.interlaceMode;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.slowPal = builder.slowPal;
        this.telecine = builder.telecine;
    }

    public ProresCodecProfile codecProfile() {
        return ProresCodecProfile.fromValue(this.codecProfile);
    }

    public String codecProfileAsString() {
        return this.codecProfile;
    }

    public ProresFramerateControl framerateControl() {
        return ProresFramerateControl.fromValue(this.framerateControl);
    }

    public String framerateControlAsString() {
        return this.framerateControl;
    }

    public ProresFramerateConversionAlgorithm framerateConversionAlgorithm() {
        return ProresFramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public ProresInterlaceMode interlaceMode() {
        return ProresInterlaceMode.fromValue(this.interlaceMode);
    }

    public String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public ProresParControl parControl() {
        return ProresParControl.fromValue(this.parControl);
    }

    public String parControlAsString() {
        return this.parControl;
    }

    public Integer parDenominator() {
        return this.parDenominator;
    }

    public Integer parNumerator() {
        return this.parNumerator;
    }

    public ProresSlowPal slowPal() {
        return ProresSlowPal.fromValue(this.slowPal);
    }

    public String slowPalAsString() {
        return this.slowPal;
    }

    public ProresTelecine telecine() {
        return ProresTelecine.fromValue(this.telecine);
    }

    public String telecineAsString() {
        return this.telecine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProresSettings)) {
            return false;
        }
        ProresSettings other = (ProresSettings)obj;
        return Objects.equals(this.codecProfileAsString(), other.codecProfileAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.parControlAsString(), other.parControlAsString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString());
    }

    public String toString() {
        return ToString.builder((String)"ProresSettings").add("CodecProfile", (Object)this.codecProfileAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("ParControl", (Object)this.parControlAsString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("SlowPal", (Object)this.slowPalAsString()).add("Telecine", (Object)this.telecineAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodecProfile": {
                return Optional.of(clazz.cast(this.codecProfileAsString()));
            }
            case "FramerateControl": {
                return Optional.of(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.of(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.of(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.of(clazz.cast(this.framerateNumerator()));
            }
            case "InterlaceMode": {
                return Optional.of(clazz.cast(this.interlaceModeAsString()));
            }
            case "ParControl": {
                return Optional.of(clazz.cast(this.parControlAsString()));
            }
            case "ParDenominator": {
                return Optional.of(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.of(clazz.cast(this.parNumerator()));
            }
            case "SlowPal": {
                return Optional.of(clazz.cast(this.slowPalAsString()));
            }
            case "Telecine": {
                return Optional.of(clazz.cast(this.telecineAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProresSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String codecProfile;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String interlaceMode;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private String slowPal;
        private String telecine;

        private BuilderImpl() {
        }

        private BuilderImpl(ProresSettings model) {
            this.codecProfile(model.codecProfile);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.interlaceMode(model.interlaceMode);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.slowPal(model.slowPal);
            this.telecine(model.telecine);
        }

        public final String getCodecProfile() {
            return this.codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(ProresCodecProfile codecProfile) {
            this.codecProfile(codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(ProresFramerateControl framerateControl) {
            this.framerateControl(framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(ProresFramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(ProresInterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final String getParControl() {
            return this.parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(ProresParControl parControl) {
            this.parControl(parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(ProresSlowPal slowPal) {
            this.slowPal(slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(ProresTelecine telecine) {
            this.telecine(telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public ProresSettings build() {
            return new ProresSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProresSettings> {
        public Builder codecProfile(String var1);

        public Builder codecProfile(ProresCodecProfile var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(ProresFramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(ProresFramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(ProresInterlaceMode var1);

        public Builder parControl(String var1);

        public Builder parControl(ProresParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder slowPal(String var1);

        public Builder slowPal(ProresSlowPal var1);

        public Builder telecine(String var1);

        public Builder telecine(ProresTelecine var1);
    }
}

