/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.AudioDescription;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDescription;
import software.amazon.awssdk.services.mediaconvert.model.ContainerSettings;
import software.amazon.awssdk.services.mediaconvert.model.ListOfAudioDescriptionCopier;
import software.amazon.awssdk.services.mediaconvert.model.ListOfCaptionDescriptionCopier;
import software.amazon.awssdk.services.mediaconvert.model.OutputSettings;
import software.amazon.awssdk.services.mediaconvert.model.VideoDescription;
import software.amazon.awssdk.services.mediaconvert.transform.OutputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Output
implements StructuredPojo,
ToCopyableBuilder<Builder, Output> {
    private final List<AudioDescription> audioDescriptions;
    private final List<CaptionDescription> captionDescriptions;
    private final ContainerSettings containerSettings;
    private final String extension;
    private final String nameModifier;
    private final OutputSettings outputSettings;
    private final String preset;
    private final VideoDescription videoDescription;

    private Output(BuilderImpl builder) {
        this.audioDescriptions = builder.audioDescriptions;
        this.captionDescriptions = builder.captionDescriptions;
        this.containerSettings = builder.containerSettings;
        this.extension = builder.extension;
        this.nameModifier = builder.nameModifier;
        this.outputSettings = builder.outputSettings;
        this.preset = builder.preset;
        this.videoDescription = builder.videoDescription;
    }

    public List<AudioDescription> audioDescriptions() {
        return this.audioDescriptions;
    }

    public List<CaptionDescription> captionDescriptions() {
        return this.captionDescriptions;
    }

    public ContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public String extension() {
        return this.extension;
    }

    public String nameModifier() {
        return this.nameModifier;
    }

    public OutputSettings outputSettings() {
        return this.outputSettings;
    }

    public String preset() {
        return this.preset;
    }

    public VideoDescription videoDescription() {
        return this.videoDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.extension());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.preset());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        return Objects.equals(this.audioDescriptions(), other.audioDescriptions()) && Objects.equals(this.captionDescriptions(), other.captionDescriptions()) && Objects.equals(this.containerSettings(), other.containerSettings()) && Objects.equals(this.extension(), other.extension()) && Objects.equals(this.nameModifier(), other.nameModifier()) && Objects.equals(this.outputSettings(), other.outputSettings()) && Objects.equals(this.preset(), other.preset()) && Objects.equals(this.videoDescription(), other.videoDescription());
    }

    public String toString() {
        return ToString.builder((String)"Output").add("AudioDescriptions", this.audioDescriptions()).add("CaptionDescriptions", this.captionDescriptions()).add("ContainerSettings", (Object)this.containerSettings()).add("Extension", (Object)this.extension()).add("NameModifier", (Object)this.nameModifier()).add("OutputSettings", (Object)this.outputSettings()).add("Preset", (Object)this.preset()).add("VideoDescription", (Object)this.videoDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDescriptions": {
                return Optional.of(clazz.cast(this.audioDescriptions()));
            }
            case "CaptionDescriptions": {
                return Optional.of(clazz.cast(this.captionDescriptions()));
            }
            case "ContainerSettings": {
                return Optional.of(clazz.cast(this.containerSettings()));
            }
            case "Extension": {
                return Optional.of(clazz.cast(this.extension()));
            }
            case "NameModifier": {
                return Optional.of(clazz.cast(this.nameModifier()));
            }
            case "OutputSettings": {
                return Optional.of(clazz.cast(this.outputSettings()));
            }
            case "Preset": {
                return Optional.of(clazz.cast(this.preset()));
            }
            case "VideoDescription": {
                return Optional.of(clazz.cast(this.videoDescription()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioDescription> audioDescriptions;
        private List<CaptionDescription> captionDescriptions;
        private ContainerSettings containerSettings;
        private String extension;
        private String nameModifier;
        private OutputSettings outputSettings;
        private String preset;
        private VideoDescription videoDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.audioDescriptions(model.audioDescriptions);
            this.captionDescriptions(model.captionDescriptions);
            this.containerSettings(model.containerSettings);
            this.extension(model.extension);
            this.nameModifier(model.nameModifier);
            this.outputSettings(model.outputSettings);
            this.preset(model.preset);
            this.videoDescription(model.videoDescription);
        }

        public final Collection<AudioDescription.Builder> getAudioDescriptions() {
            return this.audioDescriptions != null ? (Collection)this.audioDescriptions.stream().map(AudioDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder audioDescriptions(Collection<AudioDescription> audioDescriptions) {
            this.audioDescriptions = ListOfAudioDescriptionCopier.copy(audioDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(AudioDescription ... audioDescriptions) {
            this.audioDescriptions(Arrays.asList(audioDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioDescriptions(Consumer<AudioDescription.Builder> ... audioDescriptions) {
            this.audioDescriptions(Stream.of(audioDescriptions).map(c -> (AudioDescription)((AudioDescription.Builder)AudioDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAudioDescriptions(Collection<AudioDescription.BuilderImpl> audioDescriptions) {
            this.audioDescriptions = ListOfAudioDescriptionCopier.copyFromBuilder(audioDescriptions);
        }

        public final Collection<CaptionDescription.Builder> getCaptionDescriptions() {
            return this.captionDescriptions != null ? (Collection)this.captionDescriptions.stream().map(CaptionDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionDescriptions(Collection<CaptionDescription> captionDescriptions) {
            this.captionDescriptions = ListOfCaptionDescriptionCopier.copy(captionDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(CaptionDescription ... captionDescriptions) {
            this.captionDescriptions(Arrays.asList(captionDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDescriptions(Consumer<CaptionDescription.Builder> ... captionDescriptions) {
            this.captionDescriptions(Stream.of(captionDescriptions).map(c -> (CaptionDescription)((CaptionDescription.Builder)CaptionDescription.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionDescriptions(Collection<CaptionDescription.BuilderImpl> captionDescriptions) {
            this.captionDescriptions = ListOfCaptionDescriptionCopier.copyFromBuilder(captionDescriptions);
        }

        public final ContainerSettings.Builder getContainerSettings() {
            return this.containerSettings != null ? this.containerSettings.toBuilder() : null;
        }

        @Override
        public final Builder containerSettings(ContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final void setContainerSettings(ContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        public final String getExtension() {
            return this.extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        public final String getNameModifier() {
            return this.nameModifier;
        }

        @Override
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        public final OutputSettings.Builder getOutputSettings() {
            return this.outputSettings != null ? this.outputSettings.toBuilder() : null;
        }

        @Override
        public final Builder outputSettings(OutputSettings outputSettings) {
            this.outputSettings = outputSettings;
            return this;
        }

        public final void setOutputSettings(OutputSettings.BuilderImpl outputSettings) {
            this.outputSettings = outputSettings != null ? outputSettings.build() : null;
        }

        public final String getPreset() {
            return this.preset;
        }

        @Override
        public final Builder preset(String preset) {
            this.preset = preset;
            return this;
        }

        public final void setPreset(String preset) {
            this.preset = preset;
        }

        public final VideoDescription.Builder getVideoDescription() {
            return this.videoDescription != null ? this.videoDescription.toBuilder() : null;
        }

        @Override
        public final Builder videoDescription(VideoDescription videoDescription) {
            this.videoDescription = videoDescription;
            return this;
        }

        public final void setVideoDescription(VideoDescription.BuilderImpl videoDescription) {
            this.videoDescription = videoDescription != null ? videoDescription.build() : null;
        }

        public Output build() {
            return new Output(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Output> {
        public Builder audioDescriptions(Collection<AudioDescription> var1);

        public Builder audioDescriptions(AudioDescription ... var1);

        public Builder audioDescriptions(Consumer<AudioDescription.Builder> ... var1);

        public Builder captionDescriptions(Collection<CaptionDescription> var1);

        public Builder captionDescriptions(CaptionDescription ... var1);

        public Builder captionDescriptions(Consumer<CaptionDescription.Builder> ... var1);

        public Builder containerSettings(ContainerSettings var1);

        default public Builder containerSettings(Consumer<ContainerSettings.Builder> containerSettings) {
            return this.containerSettings((ContainerSettings)((ContainerSettings.Builder)ContainerSettings.builder().apply(containerSettings)).build());
        }

        public Builder extension(String var1);

        public Builder nameModifier(String var1);

        public Builder outputSettings(OutputSettings var1);

        default public Builder outputSettings(Consumer<OutputSettings.Builder> outputSettings) {
            return this.outputSettings((OutputSettings)((OutputSettings.Builder)OutputSettings.builder().apply(outputSettings)).build());
        }

        public Builder preset(String var1);

        public Builder videoDescription(VideoDescription var1);

        default public Builder videoDescription(Consumer<VideoDescription.Builder> videoDescription) {
            return this.videoDescription((VideoDescription)((VideoDescription.Builder)VideoDescription.builder().apply(videoDescription)).build());
        }
    }
}

