/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerFilter;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerFilterSettings;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerSpatialFilterSettings;
import software.amazon.awssdk.services.mediaconvert.transform.NoiseReducerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NoiseReducer
implements StructuredPojo,
ToCopyableBuilder<Builder, NoiseReducer> {
    private final String filter;
    private final NoiseReducerFilterSettings filterSettings;
    private final NoiseReducerSpatialFilterSettings spatialFilterSettings;

    private NoiseReducer(BuilderImpl builder) {
        this.filter = builder.filter;
        this.filterSettings = builder.filterSettings;
        this.spatialFilterSettings = builder.spatialFilterSettings;
    }

    public NoiseReducerFilter filter() {
        return NoiseReducerFilter.fromValue(this.filter);
    }

    public String filterAsString() {
        return this.filter;
    }

    public NoiseReducerFilterSettings filterSettings() {
        return this.filterSettings;
    }

    public NoiseReducerSpatialFilterSettings spatialFilterSettings() {
        return this.spatialFilterSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialFilterSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoiseReducer)) {
            return false;
        }
        NoiseReducer other = (NoiseReducer)obj;
        return Objects.equals(this.filterAsString(), other.filterAsString()) && Objects.equals(this.filterSettings(), other.filterSettings()) && Objects.equals(this.spatialFilterSettings(), other.spatialFilterSettings());
    }

    public String toString() {
        return ToString.builder((String)"NoiseReducer").add("Filter", (Object)this.filterAsString()).add("FilterSettings", (Object)this.filterSettings()).add("SpatialFilterSettings", (Object)this.spatialFilterSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.of(clazz.cast(this.filterAsString()));
            }
            case "FilterSettings": {
                return Optional.of(clazz.cast(this.filterSettings()));
            }
            case "SpatialFilterSettings": {
                return Optional.of(clazz.cast(this.spatialFilterSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NoiseReducerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String filter;
        private NoiseReducerFilterSettings filterSettings;
        private NoiseReducerSpatialFilterSettings spatialFilterSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(NoiseReducer model) {
            this.filter(model.filter);
            this.filterSettings(model.filterSettings);
            this.spatialFilterSettings(model.spatialFilterSettings);
        }

        public final String getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public final Builder filter(NoiseReducerFilter filter) {
            this.filter(filter.toString());
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        public final NoiseReducerFilterSettings.Builder getFilterSettings() {
            return this.filterSettings != null ? this.filterSettings.toBuilder() : null;
        }

        @Override
        public final Builder filterSettings(NoiseReducerFilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final void setFilterSettings(NoiseReducerFilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        public final NoiseReducerSpatialFilterSettings.Builder getSpatialFilterSettings() {
            return this.spatialFilterSettings != null ? this.spatialFilterSettings.toBuilder() : null;
        }

        @Override
        public final Builder spatialFilterSettings(NoiseReducerSpatialFilterSettings spatialFilterSettings) {
            this.spatialFilterSettings = spatialFilterSettings;
            return this;
        }

        public final void setSpatialFilterSettings(NoiseReducerSpatialFilterSettings.BuilderImpl spatialFilterSettings) {
            this.spatialFilterSettings = spatialFilterSettings != null ? spatialFilterSettings.build() : null;
        }

        public NoiseReducer build() {
            return new NoiseReducer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NoiseReducer> {
        public Builder filter(String var1);

        public Builder filter(NoiseReducerFilter var1);

        public Builder filterSettings(NoiseReducerFilterSettings var1);

        default public Builder filterSettings(Consumer<NoiseReducerFilterSettings.Builder> filterSettings) {
            return this.filterSettings((NoiseReducerFilterSettings)((NoiseReducerFilterSettings.Builder)NoiseReducerFilterSettings.builder().apply(filterSettings)).build());
        }

        public Builder spatialFilterSettings(NoiseReducerSpatialFilterSettings var1);

        default public Builder spatialFilterSettings(Consumer<NoiseReducerSpatialFilterSettings.Builder> spatialFilterSettings) {
            return this.spatialFilterSettings((NoiseReducerSpatialFilterSettings)((NoiseReducerSpatialFilterSettings.Builder)NoiseReducerSpatialFilterSettings.builder().apply(spatialFilterSettings)).build());
        }
    }
}

