/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.DvbNitSettings;
import software.amazon.awssdk.services.mediaconvert.model.DvbSdtSettings;
import software.amazon.awssdk.services.mediaconvert.model.DvbTdtSettings;
import software.amazon.awssdk.services.mediaconvert.model.ListOf__integerCopier;
import software.amazon.awssdk.services.mediaconvert.model.M2tsAudioBufferModel;
import software.amazon.awssdk.services.mediaconvert.model.M2tsBufferModel;
import software.amazon.awssdk.services.mediaconvert.model.M2tsEbpAudioInterval;
import software.amazon.awssdk.services.mediaconvert.model.M2tsEbpPlacement;
import software.amazon.awssdk.services.mediaconvert.model.M2tsEsRateInPes;
import software.amazon.awssdk.services.mediaconvert.model.M2tsPcrControl;
import software.amazon.awssdk.services.mediaconvert.model.M2tsRateMode;
import software.amazon.awssdk.services.mediaconvert.model.M2tsScte35Source;
import software.amazon.awssdk.services.mediaconvert.model.M2tsSegmentationMarkers;
import software.amazon.awssdk.services.mediaconvert.model.M2tsSegmentationStyle;
import software.amazon.awssdk.services.mediaconvert.transform.M2tsSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class M2tsSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, M2tsSettings> {
    private final String audioBufferModel;
    private final Integer audioFramesPerPes;
    private final List<Integer> audioPids;
    private final Integer bitrate;
    private final String bufferModel;
    private final DvbNitSettings dvbNitSettings;
    private final DvbSdtSettings dvbSdtSettings;
    private final List<Integer> dvbSubPids;
    private final DvbTdtSettings dvbTdtSettings;
    private final Integer dvbTeletextPid;
    private final String ebpAudioInterval;
    private final String ebpPlacement;
    private final String esRateInPes;
    private final Double fragmentTime;
    private final Integer maxPcrInterval;
    private final Integer minEbpInterval;
    private final Double nullPacketBitrate;
    private final Integer patInterval;
    private final String pcrControl;
    private final Integer pcrPid;
    private final Integer pmtInterval;
    private final Integer pmtPid;
    private final Integer privateMetadataPid;
    private final Integer programNumber;
    private final String rateMode;
    private final Integer scte35Pid;
    private final String scte35Source;
    private final String segmentationMarkers;
    private final String segmentationStyle;
    private final Double segmentationTime;
    private final Integer transportStreamId;
    private final Integer videoPid;

    private M2tsSettings(BuilderImpl builder) {
        this.audioBufferModel = builder.audioBufferModel;
        this.audioFramesPerPes = builder.audioFramesPerPes;
        this.audioPids = builder.audioPids;
        this.bitrate = builder.bitrate;
        this.bufferModel = builder.bufferModel;
        this.dvbNitSettings = builder.dvbNitSettings;
        this.dvbSdtSettings = builder.dvbSdtSettings;
        this.dvbSubPids = builder.dvbSubPids;
        this.dvbTdtSettings = builder.dvbTdtSettings;
        this.dvbTeletextPid = builder.dvbTeletextPid;
        this.ebpAudioInterval = builder.ebpAudioInterval;
        this.ebpPlacement = builder.ebpPlacement;
        this.esRateInPes = builder.esRateInPes;
        this.fragmentTime = builder.fragmentTime;
        this.maxPcrInterval = builder.maxPcrInterval;
        this.minEbpInterval = builder.minEbpInterval;
        this.nullPacketBitrate = builder.nullPacketBitrate;
        this.patInterval = builder.patInterval;
        this.pcrControl = builder.pcrControl;
        this.pcrPid = builder.pcrPid;
        this.pmtInterval = builder.pmtInterval;
        this.pmtPid = builder.pmtPid;
        this.privateMetadataPid = builder.privateMetadataPid;
        this.programNumber = builder.programNumber;
        this.rateMode = builder.rateMode;
        this.scte35Pid = builder.scte35Pid;
        this.scte35Source = builder.scte35Source;
        this.segmentationMarkers = builder.segmentationMarkers;
        this.segmentationStyle = builder.segmentationStyle;
        this.segmentationTime = builder.segmentationTime;
        this.transportStreamId = builder.transportStreamId;
        this.videoPid = builder.videoPid;
    }

    public M2tsAudioBufferModel audioBufferModel() {
        return M2tsAudioBufferModel.fromValue(this.audioBufferModel);
    }

    public String audioBufferModelAsString() {
        return this.audioBufferModel;
    }

    public Integer audioFramesPerPes() {
        return this.audioFramesPerPes;
    }

    public List<Integer> audioPids() {
        return this.audioPids;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public M2tsBufferModel bufferModel() {
        return M2tsBufferModel.fromValue(this.bufferModel);
    }

    public String bufferModelAsString() {
        return this.bufferModel;
    }

    public DvbNitSettings dvbNitSettings() {
        return this.dvbNitSettings;
    }

    public DvbSdtSettings dvbSdtSettings() {
        return this.dvbSdtSettings;
    }

    public List<Integer> dvbSubPids() {
        return this.dvbSubPids;
    }

    public DvbTdtSettings dvbTdtSettings() {
        return this.dvbTdtSettings;
    }

    public Integer dvbTeletextPid() {
        return this.dvbTeletextPid;
    }

    public M2tsEbpAudioInterval ebpAudioInterval() {
        return M2tsEbpAudioInterval.fromValue(this.ebpAudioInterval);
    }

    public String ebpAudioIntervalAsString() {
        return this.ebpAudioInterval;
    }

    public M2tsEbpPlacement ebpPlacement() {
        return M2tsEbpPlacement.fromValue(this.ebpPlacement);
    }

    public String ebpPlacementAsString() {
        return this.ebpPlacement;
    }

    public M2tsEsRateInPes esRateInPes() {
        return M2tsEsRateInPes.fromValue(this.esRateInPes);
    }

    public String esRateInPesAsString() {
        return this.esRateInPes;
    }

    public Double fragmentTime() {
        return this.fragmentTime;
    }

    public Integer maxPcrInterval() {
        return this.maxPcrInterval;
    }

    public Integer minEbpInterval() {
        return this.minEbpInterval;
    }

    public Double nullPacketBitrate() {
        return this.nullPacketBitrate;
    }

    public Integer patInterval() {
        return this.patInterval;
    }

    public M2tsPcrControl pcrControl() {
        return M2tsPcrControl.fromValue(this.pcrControl);
    }

    public String pcrControlAsString() {
        return this.pcrControl;
    }

    public Integer pcrPid() {
        return this.pcrPid;
    }

    public Integer pmtInterval() {
        return this.pmtInterval;
    }

    public Integer pmtPid() {
        return this.pmtPid;
    }

    public Integer privateMetadataPid() {
        return this.privateMetadataPid;
    }

    public Integer programNumber() {
        return this.programNumber;
    }

    public M2tsRateMode rateMode() {
        return M2tsRateMode.fromValue(this.rateMode);
    }

    public String rateModeAsString() {
        return this.rateMode;
    }

    public Integer scte35Pid() {
        return this.scte35Pid;
    }

    public M2tsScte35Source scte35Source() {
        return M2tsScte35Source.fromValue(this.scte35Source);
    }

    public String scte35SourceAsString() {
        return this.scte35Source;
    }

    public M2tsSegmentationMarkers segmentationMarkers() {
        return M2tsSegmentationMarkers.fromValue(this.segmentationMarkers);
    }

    public String segmentationMarkersAsString() {
        return this.segmentationMarkers;
    }

    public M2tsSegmentationStyle segmentationStyle() {
        return M2tsSegmentationStyle.fromValue(this.segmentationStyle);
    }

    public String segmentationStyleAsString() {
        return this.segmentationStyle;
    }

    public Double segmentationTime() {
        return this.segmentationTime;
    }

    public Integer transportStreamId() {
        return this.transportStreamId;
    }

    public Integer videoPid() {
        return this.videoPid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioBufferModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioFramesPerPes());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioPids());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbNitSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSdtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSubPids());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbTdtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbTeletextPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebpAudioIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebpPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.esRateInPesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPcrInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.minEbpInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullPacketBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.patInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35SourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoPid());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2tsSettings)) {
            return false;
        }
        M2tsSettings other = (M2tsSettings)obj;
        return Objects.equals(this.audioBufferModelAsString(), other.audioBufferModelAsString()) && Objects.equals(this.audioFramesPerPes(), other.audioFramesPerPes()) && Objects.equals(this.audioPids(), other.audioPids()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bufferModelAsString(), other.bufferModelAsString()) && Objects.equals(this.dvbNitSettings(), other.dvbNitSettings()) && Objects.equals(this.dvbSdtSettings(), other.dvbSdtSettings()) && Objects.equals(this.dvbSubPids(), other.dvbSubPids()) && Objects.equals(this.dvbTdtSettings(), other.dvbTdtSettings()) && Objects.equals(this.dvbTeletextPid(), other.dvbTeletextPid()) && Objects.equals(this.ebpAudioIntervalAsString(), other.ebpAudioIntervalAsString()) && Objects.equals(this.ebpPlacementAsString(), other.ebpPlacementAsString()) && Objects.equals(this.esRateInPesAsString(), other.esRateInPesAsString()) && Objects.equals(this.fragmentTime(), other.fragmentTime()) && Objects.equals(this.maxPcrInterval(), other.maxPcrInterval()) && Objects.equals(this.minEbpInterval(), other.minEbpInterval()) && Objects.equals(this.nullPacketBitrate(), other.nullPacketBitrate()) && Objects.equals(this.patInterval(), other.patInterval()) && Objects.equals(this.pcrControlAsString(), other.pcrControlAsString()) && Objects.equals(this.pcrPid(), other.pcrPid()) && Objects.equals(this.pmtInterval(), other.pmtInterval()) && Objects.equals(this.pmtPid(), other.pmtPid()) && Objects.equals(this.privateMetadataPid(), other.privateMetadataPid()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.rateModeAsString(), other.rateModeAsString()) && Objects.equals(this.scte35Pid(), other.scte35Pid()) && Objects.equals(this.scte35SourceAsString(), other.scte35SourceAsString()) && Objects.equals(this.segmentationMarkersAsString(), other.segmentationMarkersAsString()) && Objects.equals(this.segmentationStyleAsString(), other.segmentationStyleAsString()) && Objects.equals(this.segmentationTime(), other.segmentationTime()) && Objects.equals(this.transportStreamId(), other.transportStreamId()) && Objects.equals(this.videoPid(), other.videoPid());
    }

    public String toString() {
        return ToString.builder((String)"M2tsSettings").add("AudioBufferModel", (Object)this.audioBufferModelAsString()).add("AudioFramesPerPes", (Object)this.audioFramesPerPes()).add("AudioPids", this.audioPids()).add("Bitrate", (Object)this.bitrate()).add("BufferModel", (Object)this.bufferModelAsString()).add("DvbNitSettings", (Object)this.dvbNitSettings()).add("DvbSdtSettings", (Object)this.dvbSdtSettings()).add("DvbSubPids", this.dvbSubPids()).add("DvbTdtSettings", (Object)this.dvbTdtSettings()).add("DvbTeletextPid", (Object)this.dvbTeletextPid()).add("EbpAudioInterval", (Object)this.ebpAudioIntervalAsString()).add("EbpPlacement", (Object)this.ebpPlacementAsString()).add("EsRateInPes", (Object)this.esRateInPesAsString()).add("FragmentTime", (Object)this.fragmentTime()).add("MaxPcrInterval", (Object)this.maxPcrInterval()).add("MinEbpInterval", (Object)this.minEbpInterval()).add("NullPacketBitrate", (Object)this.nullPacketBitrate()).add("PatInterval", (Object)this.patInterval()).add("PcrControl", (Object)this.pcrControlAsString()).add("PcrPid", (Object)this.pcrPid()).add("PmtInterval", (Object)this.pmtInterval()).add("PmtPid", (Object)this.pmtPid()).add("PrivateMetadataPid", (Object)this.privateMetadataPid()).add("ProgramNumber", (Object)this.programNumber()).add("RateMode", (Object)this.rateModeAsString()).add("Scte35Pid", (Object)this.scte35Pid()).add("Scte35Source", (Object)this.scte35SourceAsString()).add("SegmentationMarkers", (Object)this.segmentationMarkersAsString()).add("SegmentationStyle", (Object)this.segmentationStyleAsString()).add("SegmentationTime", (Object)this.segmentationTime()).add("TransportStreamId", (Object)this.transportStreamId()).add("VideoPid", (Object)this.videoPid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioBufferModel": {
                return Optional.of(clazz.cast(this.audioBufferModelAsString()));
            }
            case "AudioFramesPerPes": {
                return Optional.of(clazz.cast(this.audioFramesPerPes()));
            }
            case "AudioPids": {
                return Optional.of(clazz.cast(this.audioPids()));
            }
            case "Bitrate": {
                return Optional.of(clazz.cast(this.bitrate()));
            }
            case "BufferModel": {
                return Optional.of(clazz.cast(this.bufferModelAsString()));
            }
            case "DvbNitSettings": {
                return Optional.of(clazz.cast(this.dvbNitSettings()));
            }
            case "DvbSdtSettings": {
                return Optional.of(clazz.cast(this.dvbSdtSettings()));
            }
            case "DvbSubPids": {
                return Optional.of(clazz.cast(this.dvbSubPids()));
            }
            case "DvbTdtSettings": {
                return Optional.of(clazz.cast(this.dvbTdtSettings()));
            }
            case "DvbTeletextPid": {
                return Optional.of(clazz.cast(this.dvbTeletextPid()));
            }
            case "EbpAudioInterval": {
                return Optional.of(clazz.cast(this.ebpAudioIntervalAsString()));
            }
            case "EbpPlacement": {
                return Optional.of(clazz.cast(this.ebpPlacementAsString()));
            }
            case "EsRateInPes": {
                return Optional.of(clazz.cast(this.esRateInPesAsString()));
            }
            case "FragmentTime": {
                return Optional.of(clazz.cast(this.fragmentTime()));
            }
            case "MaxPcrInterval": {
                return Optional.of(clazz.cast(this.maxPcrInterval()));
            }
            case "MinEbpInterval": {
                return Optional.of(clazz.cast(this.minEbpInterval()));
            }
            case "NullPacketBitrate": {
                return Optional.of(clazz.cast(this.nullPacketBitrate()));
            }
            case "PatInterval": {
                return Optional.of(clazz.cast(this.patInterval()));
            }
            case "PcrControl": {
                return Optional.of(clazz.cast(this.pcrControlAsString()));
            }
            case "PcrPid": {
                return Optional.of(clazz.cast(this.pcrPid()));
            }
            case "PmtInterval": {
                return Optional.of(clazz.cast(this.pmtInterval()));
            }
            case "PmtPid": {
                return Optional.of(clazz.cast(this.pmtPid()));
            }
            case "PrivateMetadataPid": {
                return Optional.of(clazz.cast(this.privateMetadataPid()));
            }
            case "ProgramNumber": {
                return Optional.of(clazz.cast(this.programNumber()));
            }
            case "RateMode": {
                return Optional.of(clazz.cast(this.rateModeAsString()));
            }
            case "Scte35Pid": {
                return Optional.of(clazz.cast(this.scte35Pid()));
            }
            case "Scte35Source": {
                return Optional.of(clazz.cast(this.scte35SourceAsString()));
            }
            case "SegmentationMarkers": {
                return Optional.of(clazz.cast(this.segmentationMarkersAsString()));
            }
            case "SegmentationStyle": {
                return Optional.of(clazz.cast(this.segmentationStyleAsString()));
            }
            case "SegmentationTime": {
                return Optional.of(clazz.cast(this.segmentationTime()));
            }
            case "TransportStreamId": {
                return Optional.of(clazz.cast(this.transportStreamId()));
            }
            case "VideoPid": {
                return Optional.of(clazz.cast(this.videoPid()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        M2tsSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioBufferModel;
        private Integer audioFramesPerPes;
        private List<Integer> audioPids;
        private Integer bitrate;
        private String bufferModel;
        private DvbNitSettings dvbNitSettings;
        private DvbSdtSettings dvbSdtSettings;
        private List<Integer> dvbSubPids;
        private DvbTdtSettings dvbTdtSettings;
        private Integer dvbTeletextPid;
        private String ebpAudioInterval;
        private String ebpPlacement;
        private String esRateInPes;
        private Double fragmentTime;
        private Integer maxPcrInterval;
        private Integer minEbpInterval;
        private Double nullPacketBitrate;
        private Integer patInterval;
        private String pcrControl;
        private Integer pcrPid;
        private Integer pmtInterval;
        private Integer pmtPid;
        private Integer privateMetadataPid;
        private Integer programNumber;
        private String rateMode;
        private Integer scte35Pid;
        private String scte35Source;
        private String segmentationMarkers;
        private String segmentationStyle;
        private Double segmentationTime;
        private Integer transportStreamId;
        private Integer videoPid;

        private BuilderImpl() {
        }

        private BuilderImpl(M2tsSettings model) {
            this.audioBufferModel(model.audioBufferModel);
            this.audioFramesPerPes(model.audioFramesPerPes);
            this.audioPids(model.audioPids);
            this.bitrate(model.bitrate);
            this.bufferModel(model.bufferModel);
            this.dvbNitSettings(model.dvbNitSettings);
            this.dvbSdtSettings(model.dvbSdtSettings);
            this.dvbSubPids(model.dvbSubPids);
            this.dvbTdtSettings(model.dvbTdtSettings);
            this.dvbTeletextPid(model.dvbTeletextPid);
            this.ebpAudioInterval(model.ebpAudioInterval);
            this.ebpPlacement(model.ebpPlacement);
            this.esRateInPes(model.esRateInPes);
            this.fragmentTime(model.fragmentTime);
            this.maxPcrInterval(model.maxPcrInterval);
            this.minEbpInterval(model.minEbpInterval);
            this.nullPacketBitrate(model.nullPacketBitrate);
            this.patInterval(model.patInterval);
            this.pcrControl(model.pcrControl);
            this.pcrPid(model.pcrPid);
            this.pmtInterval(model.pmtInterval);
            this.pmtPid(model.pmtPid);
            this.privateMetadataPid(model.privateMetadataPid);
            this.programNumber(model.programNumber);
            this.rateMode(model.rateMode);
            this.scte35Pid(model.scte35Pid);
            this.scte35Source(model.scte35Source);
            this.segmentationMarkers(model.segmentationMarkers);
            this.segmentationStyle(model.segmentationStyle);
            this.segmentationTime(model.segmentationTime);
            this.transportStreamId(model.transportStreamId);
            this.videoPid(model.videoPid);
        }

        public final String getAudioBufferModel() {
            return this.audioBufferModel;
        }

        @Override
        public final Builder audioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
            return this;
        }

        @Override
        public final Builder audioBufferModel(M2tsAudioBufferModel audioBufferModel) {
            this.audioBufferModel(audioBufferModel.toString());
            return this;
        }

        public final void setAudioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
        }

        public final Integer getAudioFramesPerPes() {
            return this.audioFramesPerPes;
        }

        @Override
        public final Builder audioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
            return this;
        }

        public final void setAudioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
        }

        public final Collection<Integer> getAudioPids() {
            return this.audioPids;
        }

        @Override
        public final Builder audioPids(Collection<Integer> audioPids) {
            this.audioPids = ListOf__integerCopier.copy(audioPids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioPids(Integer ... audioPids) {
            this.audioPids(Arrays.asList(audioPids));
            return this;
        }

        public final void setAudioPids(Collection<Integer> audioPids) {
            this.audioPids = ListOf__integerCopier.copy(audioPids);
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getBufferModel() {
            return this.bufferModel;
        }

        @Override
        public final Builder bufferModel(String bufferModel) {
            this.bufferModel = bufferModel;
            return this;
        }

        @Override
        public final Builder bufferModel(M2tsBufferModel bufferModel) {
            this.bufferModel(bufferModel.toString());
            return this;
        }

        public final void setBufferModel(String bufferModel) {
            this.bufferModel = bufferModel;
        }

        public final DvbNitSettings.Builder getDvbNitSettings() {
            return this.dvbNitSettings != null ? this.dvbNitSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbNitSettings(DvbNitSettings dvbNitSettings) {
            this.dvbNitSettings = dvbNitSettings;
            return this;
        }

        public final void setDvbNitSettings(DvbNitSettings.BuilderImpl dvbNitSettings) {
            this.dvbNitSettings = dvbNitSettings != null ? dvbNitSettings.build() : null;
        }

        public final DvbSdtSettings.Builder getDvbSdtSettings() {
            return this.dvbSdtSettings != null ? this.dvbSdtSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSdtSettings(DvbSdtSettings dvbSdtSettings) {
            this.dvbSdtSettings = dvbSdtSettings;
            return this;
        }

        public final void setDvbSdtSettings(DvbSdtSettings.BuilderImpl dvbSdtSettings) {
            this.dvbSdtSettings = dvbSdtSettings != null ? dvbSdtSettings.build() : null;
        }

        public final Collection<Integer> getDvbSubPids() {
            return this.dvbSubPids;
        }

        @Override
        public final Builder dvbSubPids(Collection<Integer> dvbSubPids) {
            this.dvbSubPids = ListOf__integerCopier.copy(dvbSubPids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dvbSubPids(Integer ... dvbSubPids) {
            this.dvbSubPids(Arrays.asList(dvbSubPids));
            return this;
        }

        public final void setDvbSubPids(Collection<Integer> dvbSubPids) {
            this.dvbSubPids = ListOf__integerCopier.copy(dvbSubPids);
        }

        public final DvbTdtSettings.Builder getDvbTdtSettings() {
            return this.dvbTdtSettings != null ? this.dvbTdtSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbTdtSettings(DvbTdtSettings dvbTdtSettings) {
            this.dvbTdtSettings = dvbTdtSettings;
            return this;
        }

        public final void setDvbTdtSettings(DvbTdtSettings.BuilderImpl dvbTdtSettings) {
            this.dvbTdtSettings = dvbTdtSettings != null ? dvbTdtSettings.build() : null;
        }

        public final Integer getDvbTeletextPid() {
            return this.dvbTeletextPid;
        }

        @Override
        public final Builder dvbTeletextPid(Integer dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
            return this;
        }

        public final void setDvbTeletextPid(Integer dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
        }

        public final String getEbpAudioInterval() {
            return this.ebpAudioInterval;
        }

        @Override
        public final Builder ebpAudioInterval(String ebpAudioInterval) {
            this.ebpAudioInterval = ebpAudioInterval;
            return this;
        }

        @Override
        public final Builder ebpAudioInterval(M2tsEbpAudioInterval ebpAudioInterval) {
            this.ebpAudioInterval(ebpAudioInterval.toString());
            return this;
        }

        public final void setEbpAudioInterval(String ebpAudioInterval) {
            this.ebpAudioInterval = ebpAudioInterval;
        }

        public final String getEbpPlacement() {
            return this.ebpPlacement;
        }

        @Override
        public final Builder ebpPlacement(String ebpPlacement) {
            this.ebpPlacement = ebpPlacement;
            return this;
        }

        @Override
        public final Builder ebpPlacement(M2tsEbpPlacement ebpPlacement) {
            this.ebpPlacement(ebpPlacement.toString());
            return this;
        }

        public final void setEbpPlacement(String ebpPlacement) {
            this.ebpPlacement = ebpPlacement;
        }

        public final String getEsRateInPes() {
            return this.esRateInPes;
        }

        @Override
        public final Builder esRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
            return this;
        }

        @Override
        public final Builder esRateInPes(M2tsEsRateInPes esRateInPes) {
            this.esRateInPes(esRateInPes.toString());
            return this;
        }

        public final void setEsRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
        }

        public final Double getFragmentTime() {
            return this.fragmentTime;
        }

        @Override
        public final Builder fragmentTime(Double fragmentTime) {
            this.fragmentTime = fragmentTime;
            return this;
        }

        public final void setFragmentTime(Double fragmentTime) {
            this.fragmentTime = fragmentTime;
        }

        public final Integer getMaxPcrInterval() {
            return this.maxPcrInterval;
        }

        @Override
        public final Builder maxPcrInterval(Integer maxPcrInterval) {
            this.maxPcrInterval = maxPcrInterval;
            return this;
        }

        public final void setMaxPcrInterval(Integer maxPcrInterval) {
            this.maxPcrInterval = maxPcrInterval;
        }

        public final Integer getMinEbpInterval() {
            return this.minEbpInterval;
        }

        @Override
        public final Builder minEbpInterval(Integer minEbpInterval) {
            this.minEbpInterval = minEbpInterval;
            return this;
        }

        public final void setMinEbpInterval(Integer minEbpInterval) {
            this.minEbpInterval = minEbpInterval;
        }

        public final Double getNullPacketBitrate() {
            return this.nullPacketBitrate;
        }

        @Override
        public final Builder nullPacketBitrate(Double nullPacketBitrate) {
            this.nullPacketBitrate = nullPacketBitrate;
            return this;
        }

        public final void setNullPacketBitrate(Double nullPacketBitrate) {
            this.nullPacketBitrate = nullPacketBitrate;
        }

        public final Integer getPatInterval() {
            return this.patInterval;
        }

        @Override
        public final Builder patInterval(Integer patInterval) {
            this.patInterval = patInterval;
            return this;
        }

        public final void setPatInterval(Integer patInterval) {
            this.patInterval = patInterval;
        }

        public final String getPcrControl() {
            return this.pcrControl;
        }

        @Override
        public final Builder pcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
            return this;
        }

        @Override
        public final Builder pcrControl(M2tsPcrControl pcrControl) {
            this.pcrControl(pcrControl.toString());
            return this;
        }

        public final void setPcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
        }

        public final Integer getPcrPid() {
            return this.pcrPid;
        }

        @Override
        public final Builder pcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final void setPcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
        }

        public final Integer getPmtInterval() {
            return this.pmtInterval;
        }

        @Override
        public final Builder pmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
            return this;
        }

        public final void setPmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
        }

        public final Integer getPmtPid() {
            return this.pmtPid;
        }

        @Override
        public final Builder pmtPid(Integer pmtPid) {
            this.pmtPid = pmtPid;
            return this;
        }

        public final void setPmtPid(Integer pmtPid) {
            this.pmtPid = pmtPid;
        }

        public final Integer getPrivateMetadataPid() {
            return this.privateMetadataPid;
        }

        @Override
        public final Builder privateMetadataPid(Integer privateMetadataPid) {
            this.privateMetadataPid = privateMetadataPid;
            return this;
        }

        public final void setPrivateMetadataPid(Integer privateMetadataPid) {
            this.privateMetadataPid = privateMetadataPid;
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        public final String getRateMode() {
            return this.rateMode;
        }

        @Override
        public final Builder rateMode(String rateMode) {
            this.rateMode = rateMode;
            return this;
        }

        @Override
        public final Builder rateMode(M2tsRateMode rateMode) {
            this.rateMode(rateMode.toString());
            return this;
        }

        public final void setRateMode(String rateMode) {
            this.rateMode = rateMode;
        }

        public final Integer getScte35Pid() {
            return this.scte35Pid;
        }

        @Override
        public final Builder scte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final void setScte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        public final String getScte35Source() {
            return this.scte35Source;
        }

        @Override
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        public final Builder scte35Source(M2tsScte35Source scte35Source) {
            this.scte35Source(scte35Source.toString());
            return this;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        public final String getSegmentationMarkers() {
            return this.segmentationMarkers;
        }

        @Override
        public final Builder segmentationMarkers(String segmentationMarkers) {
            this.segmentationMarkers = segmentationMarkers;
            return this;
        }

        @Override
        public final Builder segmentationMarkers(M2tsSegmentationMarkers segmentationMarkers) {
            this.segmentationMarkers(segmentationMarkers.toString());
            return this;
        }

        public final void setSegmentationMarkers(String segmentationMarkers) {
            this.segmentationMarkers = segmentationMarkers;
        }

        public final String getSegmentationStyle() {
            return this.segmentationStyle;
        }

        @Override
        public final Builder segmentationStyle(String segmentationStyle) {
            this.segmentationStyle = segmentationStyle;
            return this;
        }

        @Override
        public final Builder segmentationStyle(M2tsSegmentationStyle segmentationStyle) {
            this.segmentationStyle(segmentationStyle.toString());
            return this;
        }

        public final void setSegmentationStyle(String segmentationStyle) {
            this.segmentationStyle = segmentationStyle;
        }

        public final Double getSegmentationTime() {
            return this.segmentationTime;
        }

        @Override
        public final Builder segmentationTime(Double segmentationTime) {
            this.segmentationTime = segmentationTime;
            return this;
        }

        public final void setSegmentationTime(Double segmentationTime) {
            this.segmentationTime = segmentationTime;
        }

        public final Integer getTransportStreamId() {
            return this.transportStreamId;
        }

        @Override
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        public final Integer getVideoPid() {
            return this.videoPid;
        }

        @Override
        public final Builder videoPid(Integer videoPid) {
            this.videoPid = videoPid;
            return this;
        }

        public final void setVideoPid(Integer videoPid) {
            this.videoPid = videoPid;
        }

        public M2tsSettings build() {
            return new M2tsSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, M2tsSettings> {
        public Builder audioBufferModel(String var1);

        public Builder audioBufferModel(M2tsAudioBufferModel var1);

        public Builder audioFramesPerPes(Integer var1);

        public Builder audioPids(Collection<Integer> var1);

        public Builder audioPids(Integer ... var1);

        public Builder bitrate(Integer var1);

        public Builder bufferModel(String var1);

        public Builder bufferModel(M2tsBufferModel var1);

        public Builder dvbNitSettings(DvbNitSettings var1);

        default public Builder dvbNitSettings(Consumer<DvbNitSettings.Builder> dvbNitSettings) {
            return this.dvbNitSettings((DvbNitSettings)((DvbNitSettings.Builder)DvbNitSettings.builder().apply(dvbNitSettings)).build());
        }

        public Builder dvbSdtSettings(DvbSdtSettings var1);

        default public Builder dvbSdtSettings(Consumer<DvbSdtSettings.Builder> dvbSdtSettings) {
            return this.dvbSdtSettings((DvbSdtSettings)((DvbSdtSettings.Builder)DvbSdtSettings.builder().apply(dvbSdtSettings)).build());
        }

        public Builder dvbSubPids(Collection<Integer> var1);

        public Builder dvbSubPids(Integer ... var1);

        public Builder dvbTdtSettings(DvbTdtSettings var1);

        default public Builder dvbTdtSettings(Consumer<DvbTdtSettings.Builder> dvbTdtSettings) {
            return this.dvbTdtSettings((DvbTdtSettings)((DvbTdtSettings.Builder)DvbTdtSettings.builder().apply(dvbTdtSettings)).build());
        }

        public Builder dvbTeletextPid(Integer var1);

        public Builder ebpAudioInterval(String var1);

        public Builder ebpAudioInterval(M2tsEbpAudioInterval var1);

        public Builder ebpPlacement(String var1);

        public Builder ebpPlacement(M2tsEbpPlacement var1);

        public Builder esRateInPes(String var1);

        public Builder esRateInPes(M2tsEsRateInPes var1);

        public Builder fragmentTime(Double var1);

        public Builder maxPcrInterval(Integer var1);

        public Builder minEbpInterval(Integer var1);

        public Builder nullPacketBitrate(Double var1);

        public Builder patInterval(Integer var1);

        public Builder pcrControl(String var1);

        public Builder pcrControl(M2tsPcrControl var1);

        public Builder pcrPid(Integer var1);

        public Builder pmtInterval(Integer var1);

        public Builder pmtPid(Integer var1);

        public Builder privateMetadataPid(Integer var1);

        public Builder programNumber(Integer var1);

        public Builder rateMode(String var1);

        public Builder rateMode(M2tsRateMode var1);

        public Builder scte35Pid(Integer var1);

        public Builder scte35Source(String var1);

        public Builder scte35Source(M2tsScte35Source var1);

        public Builder segmentationMarkers(String var1);

        public Builder segmentationMarkers(M2tsSegmentationMarkers var1);

        public Builder segmentationStyle(String var1);

        public Builder segmentationStyle(M2tsSegmentationStyle var1);

        public Builder segmentationTime(Double var1);

        public Builder transportStreamId(Integer var1);

        public Builder videoPid(Integer var1);
    }
}

