/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSourceSettings;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.services.mediaconvert.transform.CaptionSelectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CaptionSelector
implements StructuredPojo,
ToCopyableBuilder<Builder, CaptionSelector> {
    private final String languageCode;
    private final CaptionSourceSettings sourceSettings;

    private CaptionSelector(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.sourceSettings = builder.sourceSettings;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public CaptionSourceSettings sourceSettings() {
        return this.sourceSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSelector)) {
            return false;
        }
        CaptionSelector other = (CaptionSelector)obj;
        return Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.sourceSettings(), other.sourceSettings());
    }

    public String toString() {
        return ToString.builder((String)"CaptionSelector").add("LanguageCode", (Object)this.languageCodeAsString()).add("SourceSettings", (Object)this.sourceSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.of(clazz.cast(this.languageCodeAsString()));
            }
            case "SourceSettings": {
                return Optional.of(clazz.cast(this.sourceSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CaptionSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private CaptionSourceSettings sourceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSelector model) {
            this.languageCode(model.languageCode);
            this.sourceSettings(model.sourceSettings);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final CaptionSourceSettings.Builder getSourceSettings() {
            return this.sourceSettings != null ? this.sourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder sourceSettings(CaptionSourceSettings sourceSettings) {
            this.sourceSettings = sourceSettings;
            return this;
        }

        public final void setSourceSettings(CaptionSourceSettings.BuilderImpl sourceSettings) {
            this.sourceSettings = sourceSettings != null ? sourceSettings.build() : null;
        }

        public CaptionSelector build() {
            return new CaptionSelector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CaptionSelector> {
        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder sourceSettings(CaptionSourceSettings var1);

        default public Builder sourceSettings(Consumer<CaptionSourceSettings.Builder> sourceSettings) {
            return this.sourceSettings((CaptionSourceSettings)((CaptionSourceSettings.Builder)CaptionSourceSettings.builder().apply(sourceSettings)).build());
        }
    }
}

